package com.hupu.tv.player.app.ui.activity

import android.content.Context
import android.content.Intent
import android.view.KeyEvent
import android.view.View
import android.webkit.*
import androidx.appcompat.app.AppCompatActivity
import androidx.recyclerview.widget.LinearLayoutManager
import androidx.recyclerview.widget.RecyclerView
import cc.taylorzhang.singleclick.onSingleClick
import com.mirkowu.basetoolbar.BaseToolbar
import com.softgarden.baselibrary.base.BaseActivity
import com.hupu.tv.player.app.R
import com.hupu.tv.player.app.app.Constants
import com.hupu.tv.player.app.base.RefreshActivity
import com.hupu.tv.player.app.bean.AssociateArticle
import com.hupu.tv.player.app.bean.NewDetailEntity
import com.hupu.tv.player.app.bean.NewsListTag
import com.hupu.tv.player.app.bean.ShareBean
import com.hupu.tv.player.app.event.RefreshPageEvent
import com.hupu.tv.player.app.ui.adapter.NewsDetailListAdapter
import com.hupu.tv.player.app.ui.adapter.NewsLabelAdapter
import com.hupu.tv.player.app.ui.contact.NewsDetailContact
import com.hupu.tv.player.app.ui.presenter.NewsDetailPresenter
import com.hupu.tv.player.app.utils.CommonUtils
import com.hupu.tv.player.app.utils.DialogUtils
import com.hupu.tv.player.app.utils.GlideUtils
import com.mirkowu.statusbarutil.StatusBarUtil
import com.softgarden.baselibrary.utils.RecyclerViewUtil
import com.softgarden.baselibrary.utils.SPUtil
import com.softgarden.baselibrary.utils.ToastUtil
import kotlinx.android.synthetic.main.activity_news_detail.*
import kotlinx.android.synthetic.main.layout_title.*
import kotlinx.android.synthetic.main.layout_title.iv_left_icon
import kotlinx.android.synthetic.main.layout_title.tv_title_middle
import kotlinx.android.synthetic.main.layout_title_live.*
import org.greenrobot.eventbus.EventBus
import java.util.regex.Matcher
import java.util.regex.Pattern


class NewsDetailActivity : RefreshActivity<NewsDetailPresenter>(), NewsDetailContact.Display {
    private var id = ""
    private var isOnPause = false
    private var isLike = false

    private lateinit var moreAdapter: NewsDetailListAdapter
    private lateinit var newsLabelAdapter: NewsLabelAdapter
    override fun setToolbar(builder: BaseToolbar.Builder): BaseToolbar.Builder? {
        return null
    }

    override val layoutId: Int
        get() = R.layout.activity_news_detail

    override fun initialize() {

        initView()
        initRecyclerView()
        initAdapter()
        initRecyclerViewLabel()
        initStatusLayout(ll_root as View)
    }

    private fun initRecyclerViewLabel() {
        recycler_label.layoutManager = LinearLayoutManager(this, RecyclerView.HORIZONTAL, false)
        newsLabelAdapter = NewsLabelAdapter(R.layout.item_news_label)
        RecyclerViewUtil.addItemDecoration(
            this,
            recycler_label,
            R.color.transparent,
            Constants.item_divider_4,
            RecyclerView.HORIZONTAL
        )
        recycler_label.adapter = newsLabelAdapter

    }

    private fun initAdapter() {
        mRecyclerView?.layoutManager = LinearLayoutManager(this)
        moreAdapter = NewsDetailListAdapter(R.layout.item_detail_news, this)
        mRecyclerView?.adapter = moreAdapter
        moreAdapter.setOnItemClickListener { adapter, view, position ->
            val intent = Intent(this, NewsDetailActivity::class.java)
            val bean = adapter.getItem(position) as? AssociateArticle
            intent.putExtra(Constants.NEWS_DETAIL, bean?.id?.toString())
            startActivity(intent)
        }

    }

    private fun initView() {
        id = intent.getStringExtra(Constants.NEWS_DETAIL) ?: ""
        tv_title_middle.text = "资讯"
        tv_title_middle.setTextColor(resources.getColor(R.color.black))
        iv_left_icon.setOnClickListener {
            finish()
        }
        iv_right_icon.visibility = View.VISIBLE
        iv_right_icon.setImageResource(R.mipmap.icon_title_share)
        iv_right_icon.onSingleClick {
            val shareBean = SPUtil.getSerializableObject<ShareBean>(Constants.COMMON_SHARE_BEAN)
            val shareIntent = Intent()
            shareIntent.action = Intent.ACTION_SEND;
            shareIntent.putExtra(Intent.EXTRA_TEXT, shareBean?.shareContent)
            shareIntent.type = "text/plain";
            //设置分享列表的标题，并且每次都显示分享列表
            startActivity(Intent.createChooser(shareIntent, shareBean?.shareTitle))
        }


        initWebView()


        ll_click_like.setOnClickListener {
            if (!(SPUtil[Constants.USER_LOGIN, false] as Boolean)) {
                DialogUtils.showLogin(this as AppCompatActivity)
                return@setOnClickListener
            }

            if (!ll_click_like.isClickable) {
                return@setOnClickListener
            }
            ll_click_like.isClickable = false
            ll_click_like.postDelayed({
                ll_click_like.isClickable = true
            }, 3000)
            presenter?.clickLike(id, isLike)
        }

    }


    fun initWebView() {
        // mWebView.setBackgroundColor(ContextCompat.getColor(this, R.color.colorTheme)); // 设置背景色
        val webSettings = mWebView.settings
        mWebView.setBackgroundColor(0)
        //如果访问的页面中要与Javascript交互，则webview必须设置支持Javascript
        webSettings.javaScriptEnabled = true
        //支持插件
        webSettings?.pluginState = WebSettings.PluginState.ON


//        //设置自适应屏幕，两者合用  这样会使加载文本时 文字变小
//        webSettings.setUseWideViewPort(true); //将图片调整到适合webview的大小
//        webSettings.setLoadWithOverviewMode(true); // 缩放至屏幕的大小
        webSettings?.setRenderPriority(WebSettings.RenderPriority.HIGH) //提高渲染的优先级

        //缩放操作
        webSettings?.setSupportZoom(true) //支持缩放，默认为true。是下面那个的前提。
        webSettings?.builtInZoomControls = true //设置内置的缩放控件。若为false，则该WebView不可缩放
        webSettings?.displayZoomControls = false //隐藏原生的缩放控件


        //开启DomStorage缓存
        webSettings?.domStorageEnabled = true
        //        //启用数据库
        webSettings?.databaseEnabled = true
        //        //设置定位的数据库路径
//        String dir = this.getApplicationContext().getDir("database", Context.MODE_PRIVATE).getPath();
//        webSettings.setGeolocationDatabasePath(dir);

        //其他细节操作
        webSettings?.cacheMode = WebSettings.LOAD_NO_CACHE //不使用缓存
        webSettings?.allowFileAccess = true //设置可以访问文件
        webSettings?.javaScriptCanOpenWindowsAutomatically = true //支持通过JS打开新窗口
        webSettings?.loadsImagesAutomatically = true //支持自动加载图片
        webSettings?.defaultTextEncodingName = "utf-8" //设置编码格式
        //支持内容重新布局
        webSettings?.layoutAlgorithm = WebSettings.LayoutAlgorithm.SINGLE_COLUMN

        //这个是加载的地址是https的，一些资源文件使用的是http方法的，
        // 从安卓4.4之后对webview安全机制有了加强，webview里面加载https url的时候，
        // 如果里面需要加载http的资源或者重定向的时候，webview会block页面加载。需要设置MixedContentMode

        webSettings?.mixedContentMode = WebSettings.MIXED_CONTENT_ALWAYS_ALLOW
        mWebView.webChromeClient = object : WebChromeClient() {
            override fun onProgressChanged(view: WebView, newProgress: Int) {
                if (mProgressBar != null) {
                    if (newProgress >= 99) {
                        mProgressBar?.visibility = View.GONE
                        mStatusLayoutManager.showSuccessLayout()
                    } else {
                        mProgressBar?.visibility = View.VISIBLE
                        mProgressBar?.progress = newProgress
                    }
                }
            }
        }
        mWebView.webViewClient = object : WebViewClient() {
            override fun onPageFinished(view: WebView, url: String) {
                super.onPageFinished(view, url)
                if (mProgressBar != null) {
                    mProgressBar?.visibility = View.GONE
                }
                ll_bottom.visibility = View.VISIBLE
            }

            override fun shouldOverrideUrlLoading(view: WebView?, request: WebResourceRequest?): Boolean {
                val url = request?.url?.toString() ?: ""
                startActivity(CommonUtils.toWeb(url))
                mWebView.postDelayed({ finish() }, 1000)
                return true
            }
        }


    }

    override fun onKeyDown(keyCode: Int, event: KeyEvent?): Boolean {
        if (mWebView.canGoBack()) {
            mWebView.goBack()
            return true
        }
        return super.onKeyDown(keyCode, event)
    }

    /**
     * 当Activity执行onResume()时让WebView执行resume
     */
    override fun onResume() {
        super.onResume()

        StatusBarUtil.setStatusBarColor(this, getColor(R.color.white))
        StatusBarUtil.setStatusBarLightMode(this, 3)

        try {
            if (isOnPause) {
                mWebView.javaClass.getMethod("onResume").invoke(mWebView, null as Array<Any?>?)
                isOnPause = false
            }
        } catch (e: Exception) {
            e.printStackTrace()
        }
    }


    /**
     * 当Activity执行onPause()时让WebView执行pause
     */
    override fun onPause() {
        super.onPause()
        try {
            mWebView.javaClass.getMethod("onPause").invoke(mWebView, null as Array<Any?>?)
            isOnPause = true
        } catch (e: java.lang.Exception) {
            e.printStackTrace()
        }
    }


    public override fun onDestroy() {
        if (mWebView != null) {
            mWebView.stopLoading()
            mWebView.destroyDrawingCache()
            mWebView.removeAllViews()
            //mWebView.loadDataWithBaseURL(null, "", "text/html", "utf-8", null);
            mWebView.clearHistory()
            mWebView.destroy()

        }
        super.onDestroy()
    }


    /**
     * 方式2：加载html文本
     *
     * @param content
     */


    fun loadText(content: String?) {
        val webSettings = mWebView.settings
        //设置自适应屏幕，两者合用
        val data = cancelStyle(content ?: "")
        val cancelHead = cancelHead(data)
        webSettings?.useWideViewPort = false //将图片调整到适合webview的大小
        webSettings?.loadWithOverviewMode = false // 缩放至屏幕的大小
        /*** 完美自适应屏幕  */
        val sb = StringBuilder()
        sb.append(cancelHead)
            .append("<html>")
            .append("<head>")
            .append("<meta charset=\\\"utf-8\\\">")
            .append("<meta id=\\\"viewport\\\" name=\\\"viewport\\\" content=\\\"width=device-width*0.9,initial-scale=1.0,maximum-scale=1.0,user-scalable=false\\\" />")
            .append("<meta name=\\\"apple-mobile-web-app-capable\\\" content=\\\"yes\\\" />")
            .append("<meta name=\\\"apple-mobile-web-app-status-bar-style\\\" content=\\\"black\\\" />")
            .append("<meta name=\\\"black\\\" name=\\\"apple-mobile-web-app-status-bar-style\\\" />")
            .append("<style>img{width:100%;}</style>")
            .append("<style>iframe{width:100%;}</style>")
            .append("<style>table{width:100%;}</style>")
            .append("<style>body{font-size:16px;}</style>")
            .append("<style>head{font-size:16px;}</style>")
            .append("<title>mWebView</title>")
        mWebView.loadDataWithBaseURL(null, sb.toString(), "text/html", "utf-8", null)

    }

    private fun cancelStyle(text: String): String {
        var content = text
        // 先把所有的style干掉 - 正则表达式
        val regEx = " style=\"(.*?)\""
        val p: Pattern = Pattern.compile(regEx)
        val m: Matcher = p.matcher(text)
        if (m.find()) {
            content = m.replaceAll("")
        }
        return content;
    }

    private fun replaceImg(content: String): String {
        var temp = content
        val regexHeight = "height:\\d"
        val regexWidth = "width:\\d"
        repeat(4) {
            temp = temp.replace(Regex(regexHeight), "height:")
            temp = temp.replace(Regex(regexWidth), "width:")
        }
        temp = temp.replace("height:px", "height:auto")
        temp = temp.replace("width:px", "width:100%")
        return temp
    }

    private fun cancelHead(text: String): String {
        var content = text
        // 去掉head
        val regEx = ".*[h]1>"
        val p: Pattern = Pattern.compile(regEx)
        val m: Matcher = p.matcher(text)
        if (m.find()) {
            content = m.replaceAll("")
        }
        return content
    }


    override fun onDetail(entity: NewDetailEntity?) {
        mStatusLayoutManager.showSuccessLayout()


        loadText(entity?.content)
        entity?.tags?.let {
            if (it.size > 3) {
                val arrayListOf = arrayListOf<NewsListTag>()
                it[0]?.let { bean ->
                    arrayListOf.add(bean)
                }
                it[1]?.let { bean ->
                    arrayListOf.add(bean)
                }
                it[2]?.let { bean ->
                    arrayListOf.add(bean)
                }
                newsLabelAdapter.setNewData(arrayListOf)
            } else {
                newsLabelAdapter.setNewData(it)
            }
        }
        setBaseInfo(entity)

        moreAdapter.setNewData(entity?.associateArticle)

    }

    private fun setBaseInfo(entity: NewDetailEntity?) {
        entity?.let {
            tv_title.text = it.title
            GlideUtils.loadAvatar(this, it.authorAvatar, iv_avatar)
            tv_name.text = it.authorName
            tv_time.text = it.releaseTime
            tv_like_count.text = it.likeCount.toString()
            isLike = it.liked
            iv_like_count.setImageResource(if (it.liked) R.mipmap.icon_detail_like_selected else R.mipmap.icon_news_like)
        }
    }

    override fun onClickSuccess(click: Boolean) {
        //网络错误，返回的结果是相同的
//        EventBus.getDefault().post(RefreshPageEvent())

        this.isLike = click
        if (isLike) {
            iv_like_count.setImageResource(R.mipmap.icon_detail_like_selected)
            ToastUtil.s("点赞成功")
            val text = tv_like_count.text.toString().toInt()
            val successText = text + 1
            tv_like_count.text = successText.toString()
        } else {
            iv_like_count.setImageResource(R.mipmap.icon_news_like)
            ToastUtil.s("取消点赞成功")
            val text = tv_like_count.text.toString().toInt()
            val successText = text - 1
            tv_like_count.text = successText.toString()
        }
    }

    override val ctx: Context
        get() = this
    override val baseActivity: BaseActivity<*>
        get() = this

    override fun loadData() {
        mStatusLayoutManager.showLoadingLayout()
        presenter?.getNewsDetail(id)
    }

}