package com.hupu.tv.player.app.ui.activity


import android.content.Context
import android.content.Intent
import android.content.pm.ActivityInfo
import android.text.TextUtils
import com.hyphenate.util.VersionUtils
import com.kongzue.dialog.v3.WaitDialog
import com.mirkowu.basetoolbar.BaseToolbar
import com.softgarden.baselibrary.base.BaseActivity
import com.softgarden.baselibrary.utils.ToastUtil
import com.hupu.tv.player.app.R
import com.hupu.tv.player.app.app.Constants
import com.hupu.tv.player.app.base.RefreshActivity
import com.hupu.tv.player.app.ui.contact.NickNameActivityContact
import com.hupu.tv.player.app.ui.presenter.NickNameActivityPresenter
import com.hupu.tv.player.app.utils.CommonUtils
import com.hupu.tv.player.app.utils.GlideEngine
import com.hupu.tv.player.app.utils.GlideUtils
import com.luck.picture.lib.PictureSelector
import com.luck.picture.lib.animators.AnimationType
import com.luck.picture.lib.config.PictureConfig
import com.luck.picture.lib.config.PictureMimeType
import com.luck.picture.lib.entity.LocalMedia
import com.luck.picture.lib.listener.OnResultCallbackListener
import com.luck.picture.lib.style.PictureWindowAnimationStyle
import com.luck.picture.lib.tools.SdkVersionUtils
import kotlinx.android.synthetic.main.activity_nick_name.*
import java.io.File


class NickNameActivity : RefreshActivity<NickNameActivityPresenter>(), NickNameActivityContact.Display {
    private var phone = ""
    private var code = ""
    private var avatar = ""
    override val layoutId: Int
        get() = R.layout.activity_nick_name

    override val baseActivity: BaseActivity<*>?
        get() = this


    override fun onLoginRequest() {
        CommonUtils.umengLogin()
        WaitDialog.dismiss()
        hideProgressDialog()
        ToastUtil.s("登录成功")
        startActivity(MainActivity::class.java)
        finish()
    }


    override fun onAvatarSuccess(avatar:String) {
        this.avatar = avatar;
        GlideUtils.loadAvatar(this, avatar, iv_add_avatar)
    }


    override val ctx: Context?
        get() = this

    override fun initialize() {
        phone = intent.getStringExtra(Constants.USER_PHONE)
        code = intent.getStringExtra(Constants.USER_CODE)

        iv_add_avatar.setOnClickListener {
            openImage()
        }
        tv_login.setOnClickListener {

            if (TextUtils.isEmpty(et_nick_name.text)) {
                ToastUtil.s("请填入昵称")
                return@setOnClickListener
            }
            presenter?.login(phone, et_nick_name.text.toString(), code, avatar)
        }
    }

    private fun openImage() {
        PictureSelector.create(this)
            .openGallery(PictureMimeType.ofImage()) // 全部.PictureMimeType.ofAll()、图片.ofImage()、视频.ofVideo()、音频.ofAudio()
            .imageEngine(GlideEngine.createGlideEngine()) // 外部传入图片加载引擎，必传项
            .setPictureWindowAnimationStyle(PictureWindowAnimationStyle.ofDefaultWindowAnimationStyle()) // 自定义相册启动退出动画
            .setRecyclerAnimationMode(AnimationType.DEFAULT_ANIMATION) // 列表动画效果
            .isMaxSelectEnabledMask(true) // 选择数到了最大阀值列表是否启用蒙层效果
            .maxSelectNum(1)
            .isWithVideoImage(true)
            .maxVideoSelectNum(1) // 视频最大选择数量
            .minSelectNum(1) // 最小选择数量
            .imageSpanCount(3) // 每行显示个数
            .closeAndroidQChangeWH(true) //如果图片有旋转角度则对换宽高,默认为true
            .closeAndroidQChangeVideoWH(!SdkVersionUtils.checkedAndroid_Q()) // 如果视频有旋转角度则对换宽高,默认为false
            .setRequestedOrientation(ActivityInfo.SCREEN_ORIENTATION_UNSPECIFIED) // 设置相册Activity方向，不设置默认使用系统
            .selectionMode(PictureConfig.SINGLE) // 多选 or 单选
            .isPreviewImage(true) // 是否可预览图片
            .isCamera(true) // 是否显示拍照按钮
            .imageFormat(PictureMimeType.PNG) // 拍照保存图片格式后缀,默认jpeg,Android Q使用PictureMimeType.PNG_Q
            .isCompress(true) // 是否压缩
            .compressQuality(50)
            .freeStyleCropEnabled(true) // 裁剪框是否可拖拽
//            .selectionData(gridImageAdapter!!.data) // 是否传入已选图片
            .cutOutQuality(90) // 裁剪输出质量 默认100
            .minimumCompressSize(100) // 小于多少kb的图片不压缩
            .forResult(object : OnResultCallbackListener<LocalMedia> {
                override fun onCancel() {}
                override fun onResult(result: MutableList<LocalMedia>?) {
                    presenter?.uploadFile(result?.get(0)?.compressPath)
                }
            })
    }

    override fun onActivityResult(requestCode: Int, resultCode: Int, data: Intent?) {
        super.onActivityResult(requestCode, resultCode, data)
        if (requestCode == REQUEST_OPEN_IMAGE) {
            onActivityResultForLocalPhotos(data)
        }
    }

    fun onActivityResultForLocalPhotos(data: Intent?) {
        if (data != null) {
            val selectedImage = data.data

            if (selectedImage != null) {
//                val filePath = UriUtils.getFilePath(activity, selectedImage)
                val filePath = CommonUtils.getRealPathFromUriAboveApiAndroidK(activity, selectedImage)
                if (!TextUtils.isEmpty(filePath) && File(filePath).exists()) {
                    presenter?.uploadFile(filePath!!)
//                    showProgressDialog("正在上传头像")
                }
            }
        }
    }

    companion object {
        fun start(context: Context) {
            val starter = Intent(context, NickNameActivity::class.java)
            //	    starter.putExtra( );
            context.startActivity(starter)
        }

        const val REQUEST_OPEN_IMAGE = 111
    }

    override fun setToolbar(builder: BaseToolbar.Builder): BaseToolbar.Builder? {
        return null
    }

    override fun loadData() {

    }
}