package com.hupu.tv.player.app.ui.activity

import android.content.Context
import android.view.View
import androidx.recyclerview.widget.LinearLayoutManager
import com.mirkowu.basetoolbar.BaseToolbar
import com.softgarden.baselibrary.base.BaseActivity
import com.softgarden.baselibrary.utils.RecyclerViewUtil
import com.softgarden.baselibrary.utils.SPUtil
import com.softgarden.baselibrary.utils.ToastUtil
import com.hupu.tv.player.app.R
import com.hupu.tv.player.app.app.Constants
import com.hupu.tv.player.app.base.ToolbarActivity
import com.hupu.tv.player.app.bean.PayTypeBean
import com.hupu.tv.player.app.event.RequestRefreshUserEvent
import com.hupu.tv.player.app.ui.adapter.PayInfoAdapter
import com.hupu.tv.player.app.ui.contact.PayInfoContract
import com.hupu.tv.player.app.ui.presenter.PayInfoPresenter
import com.hupu.tv.player.app.utils.CommonUtils
import com.hupu.tv.player.app.utils.DialogUtils
import kotlinx.android.synthetic.main.activity_pay.*
import kotlinx.android.synthetic.main.layout_title.*
import org.greenrobot.eventbus.EventBus

class PayActivity : ToolbarActivity<PayInfoPresenter>(), PayInfoContract.DisPlay {
    private var currentBean: PayTypeBean? = null
    private var id: Int = 0
    private var payType = 0

    companion object {
        const val PAY_PRICE = "pay_price"
        const val PAY_NAME = "pay_name"
        const val PAY_ID = "pay_id"
        const val PAY_TYPE = "pay_type"
        const val PAY_TYPE_VIP = 1
        const val PAY_TYPE_COIN = 2
    }


    override fun setToolbar(builder: BaseToolbar.Builder): BaseToolbar.Builder? {
        return null
    }

    override val layoutId: Int
        get() = R.layout.activity_pay

    override fun initialize() {
        setStatus()
        getIntentData()
        initRecycler()
        initView()
        initListener()

    }

    private fun initView() {
        tv_title_middle.text = "支付金额"
        ll_paying.visibility = View.GONE
        ll_pay_select.visibility = View.VISIBLE
        presenter?.gePayTypeData()
    }

    private fun initListener() {
        iv_left_icon.setOnClickListener { finish() }
        tv_pay.setOnClickListener {
            val payInterType = if (payType == PAY_TYPE_VIP) {
                Constants.VIP_PAY
            } else {
                Constants.GOLD_COINS_PAY
            }
            presenter?.pay(currentBean?.id ?: 0, id, payInterType)

//            if (payType == PAY_TYPE_VIP){
//                presenter?.payVip(currentBean?.id ?: 0, id)
//            }else{
//                presenter?.payCoin(currentBean?.id ?: 0, id)
//            }

            ll_pay_select.visibility = View.GONE
            ll_paying.visibility = View.VISIBLE
            DialogUtils.showPayTips(this, object : DialogUtils.OnClickSingleListener {
                override fun onClick() {
                    presenter?.getResult()
                }
            })
        }
        tv_pay_success.setOnClickListener {
            EventBus.getDefault().post(RequestRefreshUserEvent())
            ToastUtil.s("支付完成后，请刷新个人中心")
            finish()
        }
        tv_contact_custom.setOnClickListener {
            DialogUtils.showContact(this, object : DialogUtils.OnClickSingleListener {
                override fun onClick() {
                    if (SPUtil[Constants.CUSTOMER_TYPE, ""] as String == Constants.PLAY_TYPE) {
                        startActivity(CommonUtils.toWeb(SPUtil[Constants.CUSTOMER_LINK, ""] as String))
                    } else {
                        val contract = SPUtil[Constants.CONTRACT, ""] as String
                        CommonUtils.copy(contract)
//                    DialogUtils.showMineContactCustom(this@PayActivity)
                        DialogUtils.showFloatButton(this@PayActivity, object : DialogUtils.OnClickSingleListener {
                            override fun onClick() {
                                CommonUtils.copy(SPUtil[Constants.CONTRACT, ""] as String)
                                if (SPUtil[Constants.CONTRACT_TYPE, ""] as String == Constants.CONTRACT_QQ) {
                                    startActivity(CommonUtils.toQQ())
                                } else {
                                    startActivity(CommonUtils.toWeChat())
                                }
                            }
                        })
                    }
                }
            })
        }
    }

    private fun initRecycler() {
        recycler_pay_type.layoutManager = LinearLayoutManager(this)
        RecyclerViewUtil.addItemDecoration(this, recycler_pay_type, R.color.transparent, Constants.item_divider)
    }

    private fun getIntentData() {
        val payPrice = intent.getStringExtra(PAY_PRICE)
        val payName = intent.getStringExtra(PAY_NAME)
        payType = intent.getIntExtra(PAY_TYPE, 0)
        id = intent.getIntExtra(PAY_ID, 0)
        tv_pay_name.text = "选择<${payName}>的支付金额"
        tv_price.text = "￥" + payPrice
    }

    override fun onRequestList(list: List<PayTypeBean>?) {
        val adapter = PayInfoAdapter(R.layout.item_pay_info, list, this)
        recycler_pay_type.adapter = adapter
        adapter.bindToRecyclerView(recycler_pay_type)
        recycler_pay_type.post {
            adapter.getViewByPosition(0, R.id.iv_select)?.isSelected = true
            currentBean = adapter.getItem(0)
        }
        adapter.setOnItemClickListener { adapter, view, position ->
            list?.forEachIndexed { index, payInfoBean ->
                adapter.getViewByPosition(index, R.id.iv_select)?.isSelected = false
            }
            adapter.getViewByPosition(position, R.id.iv_select)?.isSelected = true
            currentBean = adapter.getItem(position) as PayTypeBean?
        }

    }

    override fun onRequestPay() {

    }

    override val ctx: Context?
        get() = this
    override val baseActivity: BaseActivity<*>?
        get() = this

}