package com.hupu.tv.player.app.ui.activity


import android.content.Context
import android.content.Intent
import android.text.Spannable
import android.text.SpannableStringBuilder
import android.text.TextUtils
import android.text.method.HideReturnsTransformationMethod
import android.text.method.LinkMovementMethod
import android.text.style.ClickableSpan
import android.text.style.ForegroundColorSpan
import android.util.Log
import android.view.View
import cc.taylorzhang.singleclick.onSingleClick
import com.kongzue.dialog.v3.WaitDialog
import com.mirkowu.basetoolbar.BaseToolbar
import com.softgarden.baselibrary.utils.CheckUtil
import com.softgarden.baselibrary.utils.ToastUtil
import com.hupu.tv.player.app.R
import com.hupu.tv.player.app.app.Constants
import com.hupu.tv.player.app.base.RefreshActivity
import com.hupu.tv.player.app.event.RefreshUserEvent
import com.hupu.tv.player.app.event.RegisterEvent
import com.hupu.tv.player.app.ui.contact.LoginActivityContact
import com.hupu.tv.player.app.ui.contact.RegisterActivityContact
import com.hupu.tv.player.app.ui.presenter.LoginActivityPresenter
import com.hupu.tv.player.app.ui.presenter.RegisterActivityPresenter
import com.hupu.tv.player.app.utils.CommonUtils
import com.hupu.tv.player.app.utils.DialogUtils
import com.mirkowu.statusbarutil.StatusBarUtil
import com.quanmingxing.app.widget.widget.BiggerDotPasswordTransformationMethod
import com.softgarden.baselibrary.base.BaseActivity
import kotlinx.android.synthetic.main.activity_register.*
import org.greenrobot.eventbus.EventBus


class RegisterActivity : RefreshActivity<RegisterActivityPresenter>(),
    RegisterActivityContact.Display {
    override val layoutId: Int
        get() = R.layout.activity_register

    override val baseActivity: BaseActivity<*>
        get() = this


    override fun onRegister() {
        intent.getBooleanExtra(Constants.FORCE_EXIT, false)
        WaitDialog.dismiss()
        CommonUtils.umengLogin()
        EventBus.getDefault().post(RegisterEvent())
        startActivity(MainActivity::class.java)
        finish()
    }

    override val ctx: Context
        get() = this

    override fun onResume() {
        super.onResume()
        StatusBarUtil.setStatusBarColor(this,getColor(R.color.color_F5F6F7))
        StatusBarUtil.setStatusBarLightMode(this,3)
    }
    override fun initialize() {
//        cb_agree.isChecked = true
        Log.e("loginActivity", "initialize")
        initListener()
        initBottom()
    }

    private fun initBottom() {
        val style = SpannableStringBuilder(getString(R.string.string_user_agreement_title_new))
        val oneSpan = object : ClickableSpan() {
            override fun onClick(widget: View) {
                tv_agreement.highlightColor = resources.getColor(R.color.transparent)
                DialogUtils.showLoginAgreement(
                    this@RegisterActivity,
                    getString(R.string.string_user_agreement_title_user),
                    getString(R.string.string_user_agreement)
                )

            }
        }

        val twoSpan = object : ClickableSpan() {
            override fun onClick(widget: View) {
                tv_agreement.highlightColor = resources.getColor(R.color.transparent)
                DialogUtils.showLoginAgreement(
                    this@RegisterActivity,
                    getString(R.string.string_user_agreement_title_private),
                    getString(R.string.string_user_private)
                )

            }
        }

        style.setSpan(oneSpan, 12, 16, Spannable.SPAN_EXCLUSIVE_EXCLUSIVE)
        style.setSpan(twoSpan, 19, 23, Spannable.SPAN_EXCLUSIVE_EXCLUSIVE)
        style.setSpan(
            ForegroundColorSpan(getColor(R.color.color_FC7436)),
            12,
            16,
            Spannable.SPAN_EXCLUSIVE_EXCLUSIVE
        )
        style.setSpan(
            ForegroundColorSpan(getColor(R.color.color_FC7436)),
            19,
            23,
            Spannable.SPAN_EXCLUSIVE_EXCLUSIVE
        )
        tv_agreement.movementMethod = LinkMovementMethod.getInstance()
        tv_agreement.text = style
    }

    private fun initListener() {
        et_register_password.transformationMethod = BiggerDotPasswordTransformationMethod()
        iv_show_password.setOnClickListener {
            iv_show_password.isSelected = !iv_show_password.isSelected
            if (iv_show_password.isSelected) {
                et_register_password.transformationMethod = HideReturnsTransformationMethod.getInstance()
            } else {
                et_register_password.transformationMethod = BiggerDotPasswordTransformationMethod()
            }
        }


        iv_back.setOnClickListener {
            onBackPressed()
        }
        tv_login.setOnClickListener {
            onBackPressed()
        }

        iv_register.onSingleClick {
            when {
                CheckUtil.isIllegalPhone(et_register_phone.text.toString(), "请输入正确的手机号") -> {
                }
                et_register_code.text.isNullOrEmpty() -> ToastUtil.s("请输入验证码")
                et_register_password.text.length < 6 || et_register_password.text.length > 24 -> ToastUtil.s(
                    "请输入6-15位密码"
                )
                et_nick_name.text.isNullOrEmpty() -> ToastUtil.s("请输入昵称")
                !cb_agree.isChecked -> ToastUtil.s("请阅读并同意《用户协议》和《隐私协议》")
                else -> presenter?.register(
                    et_register_phone.text.toString(),
                    et_nick_name.text.toString(),
                    et_register_code.text.toString(),
                    et_register_password.text.toString()
                )
            }
        }
        tv_get_code.onSingleClick {
            val phone = et_register_phone.text.toString()
            if (CheckUtil.isIllegalPhone(phone, "请填入正确的手机号")) {
                return@onSingleClick
            }
            presenter?.getSmsCode(phone)
            tv_get_code.start()
        }
    }


    override fun setToolbar(builder: BaseToolbar.Builder): BaseToolbar.Builder? {
        return null
    }

    override fun loadData() {

    }
}