package com.hupu.tv.player.app.ui.activity

import android.content.Context
import android.text.Editable
import android.text.TextWatcher
import androidx.recyclerview.widget.LinearLayoutManager
import com.mirkowu.basetoolbar.BaseToolbar
import com.softgarden.baselibrary.base.BaseActivity
import com.hupu.tv.player.app.R
import com.hupu.tv.player.app.base.RefreshActivity
import com.hupu.tv.player.app.bean.ReportEntity
import com.hupu.tv.player.app.ui.adapter.ReportAdapter
import com.softgarden.baselibrary.base.IBaseDisplay
import com.softgarden.baselibrary.base.IBasePresenter
import com.softgarden.baselibrary.utils.RecyclerViewUtil
import com.softgarden.baselibrary.utils.ToastUtil
import kotlinx.android.synthetic.main.activity_report.*
import kotlinx.android.synthetic.main.layout_title_live.*


class ReportActivity : RefreshActivity<IBasePresenter>(), IBaseDisplay {
    private var currentResult = ""
    override fun loadData() {

    }

    override fun setToolbar(builder: BaseToolbar.Builder): BaseToolbar.Builder? {
        return null
    }

    override val layoutId: Int
        get() = R.layout.activity_report

    override fun initialize() {
        setStatus()
        initRecyclerView()
        initAdapter()
        tv_title_middle.text = "举报"
        iv_left_icon.setOnClickListener {
            finish()
        }
        initListener()
    }

    private fun initListener() {
        et_detail.addTextChangedListener(object : TextWatcher {
            override fun afterTextChanged(s: Editable?) {
                tv_edit_number.text = (500 - (s?.length?:0)).toString()
            }

            override fun beforeTextChanged(s: CharSequence?, start: Int, count: Int, after: Int) {

            }

            override fun onTextChanged(s: CharSequence?, start: Int, before: Int, count: Int) {

            }
        })

        tv_report.setOnClickListener {
            if (currentResult.isEmpty()){
                ToastUtil.s("请选择举报原因")
                return@setOnClickListener
            }

            ToastUtil.s("提交成功,请等待审核")
            finish()
        }
    }

    private fun initAdapter() {
        mRecyclerView?.layoutManager = LinearLayoutManager(this)
        val adapter = ReportAdapter()
        mRecyclerView?.adapter = adapter
//        val arrayListOf = arrayListOf("低俗色情", "违法违规", "线下导流", "涉嫌欺诈", "辱骂我或他人", "疑似/教唆自残自杀")
        val arrayListOf = arrayListOf<ReportEntity>()
        arrayListOf.add(ReportEntity("低俗色情"))
        arrayListOf.add(ReportEntity("违法违规"))
        arrayListOf.add(ReportEntity("线下导流"))
        arrayListOf.add(ReportEntity("涉嫌欺诈"))
        arrayListOf.add(ReportEntity("辱骂我或他人"))
        arrayListOf.add(ReportEntity("疑似/教唆自残自杀"))
        adapter.setNewData(arrayListOf)
        RecyclerViewUtil.addItemDecoration(this,mRecyclerView!!,R.color.view_color,1)
        adapter.setOnItemClickListener { adapter, view, position ->
            val item = adapter.getItem(position) as ReportEntity
            adapter.data.forEach {
                it as ReportEntity
                it.isSelected = false
            }
            item.isSelected= true
            currentResult = item.report
            adapter.notifyItemRangeChanged(0,adapter.itemCount,"report")
        }

    }

    override val ctx: Context?
        get() = this
    override val baseActivity: BaseActivity<*>?
        get() = this

}