package com.hupu.tv.player.app.ui.activity

import android.content.Context
import android.content.Intent
import android.os.IBinder
import android.text.Editable
import android.text.TextWatcher
import android.view.MotionEvent
import android.view.View
import android.view.inputmethod.EditorInfo
import android.view.inputmethod.InputMethodManager
import android.widget.EditText
import androidx.appcompat.app.AppCompatActivity
import com.mirkowu.basetoolbar.BaseToolbar
import com.softgarden.baselibrary.utils.ToastUtil
import com.hupu.tv.player.app.R
import com.hupu.tv.player.app.app.Constants
import com.hupu.tv.player.app.base.RefreshActivity
import com.hupu.tv.player.app.bean.LiveBean
import com.hupu.tv.player.app.bean.MovieBean
import com.hupu.tv.player.app.bean.SearchTagBean
import com.hupu.tv.player.app.ui.adapter.LiveItemAdapter
import com.hupu.tv.player.app.ui.adapter.SearchLabelAdapter
import com.hupu.tv.player.app.ui.contact.SearchActivityContact
import com.hupu.tv.player.app.ui.presenter.SearchActivityPresenter
import com.hupu.tv.player.app.utils.DialogUtils
import com.hupu.tv.player.app.utils.KeyboardChangeUtil
import com.softgarden.baselibrary.utils.RecyclerViewUtil
import com.softgarden.baselibrary.utils.SPUtil
import kotlinx.android.synthetic.main.activity_search.*


class SearchActivity : RefreshActivity<SearchActivityPresenter>(), SearchActivityContact.Display {
    private var searchKey = ""
    private var localAdapter = SearchLabelAdapter()
    private var liveItemAdapter = LiveItemAdapter()
    override val layoutId: Int
        get() = R.layout.activity_search

    override val baseActivity: SearchActivity
        get() = this

    override fun onSearchData(list: List<LiveBean.DataListBean>?) {
        setLoadMore(liveItemAdapter, list)
    }


    override fun updateLocalData(list: ArrayList<String>) {
        if (list.isNotEmpty()) {
            ll_history.visibility = View.VISIBLE
        } else {
            ll_history.visibility = View.GONE
        }
        localAdapter.setNewData(list)
    }

    override fun onShowLocalData(list: ArrayList<String>?) {
        if (list?.isNotEmpty() == true) {
            ll_history.visibility = View.VISIBLE
            localAdapter.setNewData(list)
        }
    }

    override fun onHotList(list: ArrayList<SearchTagBean>?) {

    }

    override val ctx: Context
        get() = this

    override fun initialize() {
        operateKeyBoard()
        initRefreshLayout()
        initRecyclerView()
        initAdapter()
        initListener()
        presenter?.showLocalData()
    }

    private fun initListener() {
        tv_cancel.setOnClickListener {
            onBackPressed()
        }
        iv_delete.setOnClickListener {
            presenter?.clearLocalData()
        }

    }

    private fun initAdapter() {
        recycler_local.apply {
            adapter = localAdapter.apply {
                setOnItemClickListener { adapter, view, position ->
                    mPage = PageStart
                    searchKey = adapter.getItem(position) as String
                    et_search.setText(searchKey)
                    presenter?.searchData(searchKey, true, mPage)
                }
            }
        }
        mRecyclerView?.adapter = liveItemAdapter
        if (mRecyclerView?.itemDecorationCount == 0) {
            RecyclerViewUtil.addGridItemDecoration(this, mRecyclerView!!, R.color.transparent, Constants.item_divider_4 * 2)
        }
        liveItemAdapter.setOnItemClickListener { adapter, view, position ->
            val item: LiveBean.DataListBean = adapter.getItem(position) as LiveBean.DataListBean
            val intent = Intent(activity, LiveActivity::class.java)
            intent.putExtra(Constants.ROOM_ID, item.roomId)
            intent.putExtra(Constants.ROOM_COVER, item.matchCutImg)
            startActivity(intent)
        }
    }

    override fun setToolbar(builder: BaseToolbar.Builder): BaseToolbar.Builder? {
        return null
    }

    override fun loadData() {
        if (searchKey.isNotEmpty()){
            presenter?.searchData(searchKey,true,mPage)
        }
//        presenter?.getHotTag()
    }
    /* ---------------------------以下代码，皆为键盘的操作------------------------------*/
    /**
     * 软键盘和editText
     */
    private fun operateKeyBoard() {
        //键盘弹出和收起的监听
        KeyboardChangeUtil(this).setOnKeyboardChangeListener(object :
            KeyboardChangeUtil.KeyboardChangeListener {
            override fun onKeyboardShow(keyboardHight: Int) {
                ll_label.visibility = View.VISIBLE
            }

            override fun onKeyboardHide() {

            }
        })
        //键盘右下角改为搜索
        et_search.setOnEditorActionListener { v, actionId, event ->
            var handler = false
            if (actionId == EditorInfo.IME_ACTION_SEARCH) {
                mPage = 1
                searchKey = et_search.text.toString()
                if (searchKey.isEmpty()) {
                    ToastUtil.s("请输入关键字")
                } else {
                    presenter?.searchData(searchKey, true, mPage)
                }

                handler = true
                /*隐藏软键盘*/
                hideKeyboard(this.currentFocus?.windowToken)
                val inputMethodManager =
                    getSystemService(Context.INPUT_METHOD_SERVICE) as InputMethodManager
                if (inputMethodManager.isActive) {
                    inputMethodManager.hideSoftInputFromWindow(this.currentFocus?.windowToken, 0)
                }
            }

            handler
        }
        et_search.addTextChangedListener(object : TextWatcher {
            override fun beforeTextChanged(s: CharSequence?, start: Int, count: Int, after: Int) {

            }

            override fun onTextChanged(s: CharSequence?, start: Int, before: Int, count: Int) {


            }

            override fun afterTextChanged(s: Editable?) {

            }
        })
    }

    //事件分发方法重写，并且点击非editText 收起软键盘
    override fun dispatchTouchEvent(ev: MotionEvent): Boolean {
        //如果是点击事件，获取点击的view，并判断是否要收起键盘
        if (ev.action == MotionEvent.ACTION_DOWN) {
            //获取目前得到焦点的view
            val v = currentFocus
            //判断是否要收起并进行处理

            if (isShouldHideKeyboard(v, ev)) {
                hideKeyboard(v?.windowToken)
            }
        }
        //这个是activity的事件分发，一定要有，不然就不会有任何的点击事件了
        return super.dispatchTouchEvent(ev)
    }


    //判断是否要收起键盘
    private fun isShouldHideKeyboard(v: View?, event: MotionEvent): Boolean {
        //如果目前得到焦点的这个view是editText的话进行判断点击的位置
        if (v is EditText) {
            val l = intArrayOf(0, 0)
            v.getLocationInWindow(l)
            val left = l[0]
            val top = l[1]
            val bottom = top + v.getHeight()
            val right = left + v.getWidth()
            // 点击EditText的事件，忽略它。
            return (event.x <= left || event.x >= right
                    || event.y <= top || event.y >= bottom)
        }
        // 如果焦点不是EditText则忽略，这个发生在视图刚绘制完，第一个焦点不在EditText上
        return false
    }

    //隐藏软键盘并让editText失去焦点
    private fun hideKeyboard(token: IBinder?) {
        et_search.clearFocus()
        token?.let {
            //这里先获取InputMethodManager再调用他的方法来关闭软键盘
            //InputMethodManager就是一个管理窗口输入的manager
            val im = getSystemService(Context.INPUT_METHOD_SERVICE) as InputMethodManager
            if (im.isActive) {
                im.hideSoftInputFromWindow(it, InputMethodManager.HIDE_NOT_ALWAYS)
            }

        }

    }
}