//package com.hupu.tv.player.app.ui.activity
//
//import android.Manifest
//import android.content.Context
//import android.content.Intent
//import android.content.pm.PackageManager
//import android.net.Uri
//import android.os.Build
//
//import android.view.View
//import androidx.core.content.FileProvider
//import androidx.recyclerview.widget.LinearLayoutManager
//import com.arialyy.annotations.Download
//import com.arialyy.aria.core.Aria
//import com.arialyy.aria.core.download.m3u8.M3U8VodOption
//import com.arialyy.aria.core.inf.IEntity
//import com.arialyy.aria.core.task.DownloadTask
//import com.mirkowu.basetoolbar.BaseToolbar
//import com.softgarden.baselibrary.base.BaseActivity
//import com.softgarden.baselibrary.utils.RecyclerViewUtil
//import com.softgarden.baselibrary.utils.RxPermissionsUtil
//import com.softgarden.baselibrary.utils.ToastUtil
//import com.hupu.tv.player.app.R
//import com.hupu.tv.player.app.app.Constants
//import com.hupu.tv.player.app.base.RefreshActivity
//import com.hupu.tv.player.app.bean.MovieBean
//import com.hupu.tv.player.app.event.DownloadEvent
//import com.hupu.tv.player.app.ui.adapter.MineDownloadMoreAdapter
//import com.hupu.tv.player.app.ui.adapter.MineDownloadMoreFinishAdapter
//import com.hupu.tv.player.app.ui.contact.SeeMoreDownloadActivityContact
//import com.hupu.tv.player.app.ui.presenter.SeeMoreDownloadActivityPresenter
//import com.hupu.tv.player.app.utils.CommonUtils
//import kotlinx.android.synthetic.main.activity_see_more_download.*
//import kotlinx.android.synthetic.main.layout_title.*
//import org.greenrobot.eventbus.EventBus
//import java.io.File
//
//
///**
// * @author by Dell
// * @date on 2020/7/1
// * @describe
// */
//class SeeMoreDownloadActivity : RefreshActivity<SeeMoreDownloadActivityPresenter>(), SeeMoreDownloadActivityContact.DisPlay {
//    private var downloadNowAdapter: MineDownloadMoreAdapter? = null
//    private var downloadFinishAdapter: MineDownloadMoreFinishAdapter? = null
//    private var urlList: ArrayList<String>? = null
//    private var isStart = false
//    private var isEdit = false
//    private var option: M3U8VodOption? = null
//    private var listCount = 0
//
//    override fun loadData() {
//    }
//
//    override fun setToolbar(builder: BaseToolbar.Builder): BaseToolbar.Builder? {
//        return null
//    }
//
//    override val layoutId: Int
//        get() = R.layout.activity_see_more_download
//
//    override fun initialize() {
//        initDownload()
//        setStatus()
//        initRecycler()
//        setEditFunction()
//        initTitle()
//    }
//
//    private fun initDownload() {
//        Aria.download(this).register()
//        Aria.get(this).downloadConfig.isConvertSpeed = true
//        //2个任务
//        Aria.get(this).downloadConfig.maxTaskNum = 2
//        option = M3U8VodOption()
//        //忽略下载失败的ts文件，仍然合并
//        option?.ignoreFailureTs()
//        //使用默认的解码器
//        option?.setUseDefConvert(true)
//        option?.merge(true)
////        m3U8VodOption.generateIndexFile()
//    }
//
//    private fun resumeDownload(taskId: Long) {
//        Aria.download(this)
//                .load(taskId)     //读取任务id
//                .m3u8VodOption(option)
//                .resume()   // 恢复任务
//    }
//
//    private fun stopDownload(taskId: Long) {
//        Aria.download(this)
//                .load(taskId) //读取任务id
//                .m3u8VodOption()
//                .stop()       // 停止任务
//    }
//
//    @Download.onTaskStop
//    fun stop(task: DownloadTask?) {
//        refreshStatus(task)
//    }
//
//    @Download.onWait
//    fun taskWait(task: DownloadTask?) {
//        refreshStatus(task)
//    }
//
//    @Download.onTaskFail
//    fun taskFailed(task: DownloadTask?) {
//        refreshStatus(task)
//    }
//
//    private fun refreshStatus(task: DownloadTask?) {
//        val recordsBean = MovieBean.RecordsBean()
//        val downloadList = downloadNowAdapter?.data
//        task?.let { downloadTask ->
//            downloadList?.forEach {
//                if (it.videoFullUrl == downloadTask.key) {
//                    recordsBean.videoFullUrl = downloadTask.key
//                    recordsBean.videoSpeed = downloadTask.convertSpeed //转换单位后的下载速度，单位转换需要在配置文件中打开
//                    recordsBean.state = downloadTask.state
//                    recordsBean.progress = downloadTask.percent //任务进度百分比
//                    recordsBean.localUrl = downloadTask.filePath
//                }
//            }
//            notifyChanged(recordsBean)
//        }
//    }
//
//    @Download.onTaskRunning
//    fun running(task: DownloadTask?) {
//        isStart = true
//        tv_start.text = "全部暂停"
//        iv_start.setImageResource(R.mipmap.icon_download_pause)
//        var isPause = false
//        val recordsBean = MovieBean.RecordsBean()
//        val downloadList = downloadNowAdapter?.data
//        task?.let { downloadTask ->
//            downloadList?.forEach {
//                if (it.videoFullUrl == downloadTask.key) {
//                    recordsBean.videoFullUrl = downloadTask.key
//                    recordsBean.videoSpeed = downloadTask.convertSpeed //转换单位后的下载速度，单位转换需要在配置文件中打开
//                    recordsBean.state = downloadTask.state
//                    recordsBean.progress = downloadTask.percent //任务进度百分比
//                    recordsBean.localUrl = downloadTask.filePath
//                    recordsBean.videoSize = downloadTask.convertCurrentProgress
//                }
//                if (recordsBean.state == IEntity.STATE_STOP) {
//                    isPause = true
//                }
//            }
//            if (isPause) {
//                isStart = false
//                tv_start.text = "全部开始"
//                iv_start.setImageResource(R.mipmap.icon_download_start)
//            }
//            notifyChanged(recordsBean)
//        }
//    }
//
//    @Download.onTaskComplete
//    fun taskComplete(task: DownloadTask?) {
//        //在这里处理任务完成的状态
//        val list = CommonUtils.downloadList
//        list?.forEach {
//            if (it.videoFullUrl == task?.key) {
//                it.isDownloadFinish = true
//                it.localUrl = task?.filePath
//            }
//        }
//        CommonUtils.saveDownloadList(list)
//        see_more_recycler_view.postDelayed({ presenter?.getMovieDownload() }, 1000)
//    }
//
//
//    private fun setEditFunction() {
//        downloadNowAdapter?.setOnItemChildClickListener { adapter, view, position ->
//            if (view.id == R.id.iv_select) {
//                view.isSelected = !view.isSelected
//                val item = adapter.getItem(position) as MovieBean.RecordsBean
//                item.isSelected = view.isSelected
//            }
//            var count = 0
//            downloadFinishAdapter?.data?.forEach {
//                val recordsBean = it as MovieBean.RecordsBean
//                if (recordsBean.isSelected) {
//                    count++
//                }
//            }
//            downloadNowAdapter?.data?.forEach {
//                val recordsBean = it as MovieBean.RecordsBean
//                if (recordsBean.isSelected) {
//                    count++
//                }
//            }
//            tv_delete.text = "删除($count)"
//        }
//        downloadFinishAdapter?.setOnItemChildClickListener { adapter, view, position ->
//            if (view.id == R.id.iv_select) {
//                view.isSelected = !view.isSelected
//                val item = adapter.getItem(position) as MovieBean.RecordsBean
//                item.isSelected = view.isSelected
//            }
//            var count = 0
//            downloadFinishAdapter?.data?.forEach {
//                val recordsBean = it as MovieBean.RecordsBean
//                if (recordsBean.isSelected) {
//                    count++
//                }
//            }
//            downloadNowAdapter?.data?.forEach {
//                val recordsBean = it as MovieBean.RecordsBean
//                if (recordsBean.isSelected) {
//                    count++
//                }
//            }
//            tv_delete.text = "删除($count)"
//        }
//
//    }
//
//    private fun initRecycler() {
//        downloadNowAdapter = MineDownloadMoreAdapter(R.layout.item_home_download_more, this)
//        downloadFinishAdapter = MineDownloadMoreFinishAdapter(R.layout.item_home_download_more, this)
//        see_more_recycler_view.layoutManager = LinearLayoutManager(activity)
//        RecyclerViewUtil.addItemDecoration(this, see_more_recycler_view, R.color.transparent, Constants.item_divider)
//        see_more_recycler_view_more.layoutManager = LinearLayoutManager(activity)
//        RecyclerViewUtil.addItemDecoration(this, see_more_recycler_view_more, R.color.transparent, Constants.item_divider)
//        see_more_recycler_view.adapter = downloadNowAdapter
//        see_more_recycler_view_more.adapter = downloadFinishAdapter
//
////        M3U8Downloader.getInstance().setOnM3U8DownloadListener(onM3U8DownloadListener);
//        setAdapterListener()
//
//
//        ll_start.setOnClickListener {
//            if (isStart) {
//                downloadNowAdapter?.data?.forEach {
//                    startTask(it)
//                }
//                iv_start.setImageResource(R.mipmap.icon_download_start)
//                tv_start.text = "全部开始"
//                isStart = false
//            } else {
//                downloadNowAdapter?.data?.forEach {
//                    startTask(it)
//                }
//                iv_start.setImageResource(R.mipmap.icon_download_pause)
//                tv_start.text = "全部暂停"
//                isStart = true
//            }
//
//        }
//        presenter?.getMovieDownload()
//    }
//
//    private fun setAdapterListener() {
//        downloadNowAdapter?.setOnItemClickListener { adapter, view, position ->
//            val item = adapter.getItem(position) as MovieBean.RecordsBean
//            startTask(item)
//        }
//        downloadFinishAdapter?.setOnItemClickListener { adapter, view, position ->
//            val item = adapter.getItem(position) as MovieBean.RecordsBean
//            playLocalVideo(item)
//        }
//        downloadNowAdapter?.setOnNotifyListener {
//            val nowList = downloadNowAdapter?.data as ArrayList<MovieBean.RecordsBean>
//            val finishList = downloadFinishAdapter?.data as ArrayList<MovieBean.RecordsBean>
//            nowList.addAll(finishList)
//            CommonUtils.saveDownloadList(nowList)
//        }
//    }
//
//    private fun startTask(item: MovieBean.RecordsBean) {
//        when (item.state) {
//            IEntity.STATE_RUNNING -> {
//                stopDownload(item.taskId)
//            }
//            IEntity.STATE_STOP -> {
//                resumeDownload(item.taskId)
//            }
//            else -> {
//                requestPerMission(item.videoFullUrl)
//            }
//        }
//    }
//
//    override fun onBackPressed() {
//        val nowList = downloadNowAdapter?.data as ArrayList<MovieBean.RecordsBean>
//        val finishList = downloadFinishAdapter?.data as ArrayList<MovieBean.RecordsBean>
//        nowList.addAll(finishList)
//        CommonUtils.saveDownloadList(nowList)
//        super.onBackPressed()
//    }
//
//    private fun playLocalVideo(item: MovieBean.RecordsBean) {
//        val REQUEST_CODE_CONTACT = 101
//        val permissions = arrayOf(Manifest.permission.WRITE_EXTERNAL_STORAGE)
//        permissions.forEach {
//            //验证是否许可权限
//            if (this.checkSelfPermission(it) != PackageManager.PERMISSION_GRANTED) {
//                //申请权限
//                this.requestPermissions(permissions, REQUEST_CODE_CONTACT)
//                return
//            } else {
//                //***************************************************************************************
//                // 这里就是权限打开之后自己要操作的逻辑
//                val file1 = File(item.localUrl)
//                if (!file1.exists()) {
//                    file1.mkdirs()
//                }
//                val file = File(file1.absolutePath)
//                val uri: Uri?
//                uri = if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.N) {
//                    FileProvider.getUriForFile(this, "com.video.player.hszb.FileProvider", file)
//                } else {
//                    Uri.fromFile(file)
//                }
//                val intent = Intent(Intent.ACTION_VIEW)
//                intent.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK or Intent.FLAG_ACTIVITY_CLEAR_TASK)
//                intent.addFlags(Intent.FLAG_GRANT_READ_URI_PERMISSION)
//                intent.setDataAndType(uri, "video/*")
//                startActivity(intent)
//            }
//        }
//    }
//
//    private fun requestPerMission(link: String) {
//        RxPermissionsUtil.check(this, RxPermissionsUtil.STORAGE, "温馨提示", object : RxPermissionsUtil.OnPermissionRequestListener {
//            override fun onSucceed() {
//                startDownload(link)
//            }
//
//            override fun onFailed() {
//                ToastUtil.s("下载功能需要开启权限")
//            }
//        })
//    }
//
//    private fun startDownload(link: String) {
//        val split = link.split("/")
////        val path = Environment.getExternalStorageDirectory().absolutePath + File.separator + split[split.size - 2] + ".ts"
//        val path = filesDir.path + File.separator + split[split.size - 2] + ".ts"
//
//        val id = Aria.download(this)
//                .load(link)    //读取下载地址
//                .ignoreFilePathOccupy()//忽略相同路径
//                .m3u8VodOption(option)
//                .setFilePath(path)
//                //设置文件保存的完整路径
//                .create()  //创建
//        val downloadList = CommonUtils.downloadList
//        downloadNowAdapter?.data?.forEach {
//            if (it.videoFullUrl == link) {
//                it.taskId = id
//            }
//        }
//        downloadList.forEach {
//            if (it.videoFullUrl == link) {
//                it.taskId = id
//            }
//        }
//        CommonUtils.saveDownloadList(downloadList)
//    }
//
//    private fun initTitle() {
//        iv_left_icon.setOnClickListener { finish() }
//        tv_title_middle.text = "我的下载"
//        tv_title_right.text = "编辑"
//        tv_title_right.visibility = View.VISIBLE
//        downloadNowAdapter?.setEditStatus(isEdit)
//        downloadFinishAdapter?.setEditStatus(isEdit)
//        tv_title_right.setOnClickListener {
//            isEdit = !isEdit
//            if (isEdit) {
//                tv_title_right.text = "取消"
//                ll_select.visibility = View.VISIBLE
//            } else {
//                tv_title_right.text = "编辑"
//                ll_select.visibility = View.GONE
//            }
//            downloadNowAdapter?.setEditStatus(isEdit)
//            downloadFinishAdapter?.setEditStatus(isEdit)
//        }
//        tv_select_all.setOnClickListener {
//            var count = 0
//
//
//            downloadNowAdapter?.data?.forEach {
//                it.isSelected = true
//                count++
//            }
//            downloadFinishAdapter?.data?.forEach {
//                it.isSelected = true
//                count++
//            }
//            tv_delete.text = "删除($count)"
//            downloadNowAdapter?.data?.size?.let {
//                downloadNowAdapter?.notifyItemRangeChanged(0, it, "refresh")
//            }
//            downloadFinishAdapter?.data?.size?.let {
//                downloadFinishAdapter?.notifyItemRangeChanged(0, it, "refresh")
//            }
//        }
//        tv_delete.setOnClickListener {
//            var list = arrayListOf<MovieBean.RecordsBean>()
//            downloadNowAdapter?.data?.forEachIndexed { index, recordsBean ->
//                if (recordsBean.isSelected) {
//                    list.add(recordsBean)
//                }
//            }
//            downloadFinishAdapter?.data?.forEachIndexed { index, recordsBean ->
//                if (recordsBean.isSelected) {
//                    list.add(recordsBean)
//                }
//            }
//            list.forEach {
//                Aria.download(this)
//                        .load(it.taskId) //读取任务id
//                        .removeRecord()    // 删除任务
//            }
//
//            presenter?.deleteMovie(list)
//            isEdit = !isEdit
//            tv_title_right.text = "编辑"
//            ll_select.visibility = View.GONE
//            downloadNowAdapter?.setEditStatus(isEdit)
//            downloadFinishAdapter?.setEditStatus(isEdit)
//
//        }
//    }
//
//
//    private fun notifyChanged(bean: MovieBean.RecordsBean) {
//        runOnUiThread {
//            downloadNowAdapter?.notifyChanged(downloadNowAdapter?.data as ArrayList<MovieBean.RecordsBean>, bean)
//        }
//    }
//
//
//    override fun onRequestMovieDownloadList(list: ArrayList<MovieBean.RecordsBean>?) {
//        downloadNowAdapter?.setNewData(list)
//        if (list?.isNotEmpty() == true) {
//            ll_start.postDelayed({ ll_start.visibility = View.VISIBLE }, 500)
//        } else {
//            ll_start.postDelayed({ ll_start.visibility = View.GONE }, 500)
//        }
//        val data = downloadNowAdapter?.data
//        urlList = arrayListOf<String>()
//        data?.forEach {
//            urlList?.add(it.videoFullUrl)
//        }
//        listCount += list?.size ?: 0
//    }
//
//    override fun onRequestMovieDownloadFinishList(list: ArrayList<MovieBean.RecordsBean>?) {
//        tv_more.visibility = View.VISIBLE
//        if (list == null || list.isEmpty()) {
//            tv_more.visibility = View.GONE
//        }
//        listCount += list?.size ?: 0
//        downloadFinishAdapter?.setNewData(list)
//        EventBus.getDefault().post(DownloadEvent(null, true))
//        if (listCount == 0) {
//            ll_empty.visibility = View.VISIBLE
//        } else {
//            ll_empty.visibility = View.GONE
//        }
//    }
//
//
//    override val ctx: Context?
//        get() = this
//    override val baseActivity: BaseActivity<*>?
//        get() = this
//}