package com.hupu.tv.player.app.ui.activity

import android.content.Context
import cc.taylorzhang.singleclick.onSingleClick
import com.hupu.tv.player.app.BuildConfig
import com.mirkowu.basetoolbar.BaseToolbar
import com.softgarden.baselibrary.base.BaseActivity
import com.softgarden.baselibrary.base.IBaseDisplay
import com.softgarden.baselibrary.base.IBasePresenter
import com.softgarden.baselibrary.utils.SPUtil
import com.hupu.tv.player.app.R
import com.hupu.tv.player.app.app.Constants
import com.hupu.tv.player.app.base.RefreshActivity
import com.hupu.tv.player.app.bean.UpdateEntity
import com.hupu.tv.player.app.event.RefreshUserEvent
import com.hupu.tv.player.app.event.UserExitEvent
import com.hupu.tv.player.app.ui.contact.SettingContact
import com.hupu.tv.player.app.ui.presenter.SettingPresenter
import com.hupu.tv.player.app.utils.DialogUtils
import com.mirkowu.statusbarutil.StatusBarUtil
import com.softgarden.baselibrary.utils.ActivityManager
import com.softgarden.baselibrary.utils.ToastUtil
import kotlinx.android.synthetic.main.activity_setting.*
import kotlinx.android.synthetic.main.layout_title.*
import org.greenrobot.eventbus.EventBus
import org.greenrobot.eventbus.Subscribe
import org.greenrobot.eventbus.ThreadMode


class SettingActivity : RefreshActivity<SettingPresenter>(), SettingContact.Display {
    private var isLogin = false
    override fun loadData() {

    }

    override fun setToolbar(builder: BaseToolbar.Builder): BaseToolbar.Builder? {
        return null
    }

    override val layoutId: Int
        get() = R.layout.activity_setting

    override fun initialize() {
        EventBus.getDefault().register(this)
        setStatus()
        tv_title_middle.text = "设置"
        iv_left_icon.setOnClickListener {
            finish()
        }
        switch_message.isChecked = SPUtil[Constants.SWITCH_MESSAGE, false] as Boolean
        switch_start_back.isChecked = SPUtil[Constants.SWITCH_START_BACK, false] as Boolean
        switch_start_match.isChecked = SPUtil[Constants.SWITCH_START_MATCH, false] as Boolean
        switch_start_play.isChecked = SPUtil[Constants.SWITCH_START_PLAY, false] as Boolean
        switch_start_small.isChecked = SPUtil[Constants.SWITCH_START_SMALL, false] as Boolean
        setListener()
    }

    @Subscribe(threadMode = ThreadMode.MAIN, sticky = true, priority = 1)
    fun onEventRefreshUser(event: RefreshUserEvent) {
        isLogin = SPUtil[Constants.USER_LOGIN, false] as Boolean
    }


    private fun setListener() {
        isLogin = SPUtil[Constants.USER_LOGIN, false] as Boolean
        ll_account.onSingleClick {
            startActivity(AccountSettingActivity::class.java)
        }

        ll_user.onSingleClick {
            startActivity(UserAgreementActivity::class.java)
        }

        ll_private.onSingleClick {
            startActivity(UserPrivateActivity::class.java)
        }

        switch_message.setOnCheckedChangeListener { buttonView, isChecked ->
            SPUtil.put(Constants.SWITCH_MESSAGE, isChecked)
        }
        switch_start_back.setOnCheckedChangeListener { buttonView, isChecked ->
            SPUtil.put(Constants.SWITCH_START_BACK, isChecked)
        }
        switch_start_match.setOnCheckedChangeListener { buttonView, isChecked ->
            SPUtil.put(Constants.SWITCH_START_MATCH, isChecked)
        }
        switch_start_play.setOnCheckedChangeListener { buttonView, isChecked ->
            SPUtil.put(Constants.SWITCH_START_PLAY, isChecked)
        }
        switch_start_small.setOnCheckedChangeListener { buttonView, isChecked ->
            SPUtil.put(Constants.SWITCH_START_SMALL, isChecked)
        }


        tv_version.text = BuildConfig.VERSION_NAME

        ll_about.onSingleClick {
            startActivity(AboutActivity::class.java)
        }

        ll_version.onSingleClick {
            presenter?.checkVersion()
        }

        tv_exit_login.onSingleClick {
            presenter?.exitLogin()

        }

        tv_destroy_user.onSingleClick {
            DialogUtils.showDestroyUser(this) {
                presenter?.destroyUser()
            }
        }
    }

    override fun onExit() {
        EventBus.getDefault().post(UserExitEvent())
        finish()
    }

    override fun onCheckVersion(isUpdate: Boolean, updateEntity: UpdateEntity?) {
        if (isUpdate) {
            presenter?.update(updateEntity)
        } else {
            ToastUtil.s("当前是最新版本")
        }
    }


    override fun onDestroy() {
        super.onDestroy()
        EventBus.getDefault().unregister(this)
    }

    override val ctx: Context?
        get() = this
    override val baseActivity: BaseActivity<*>?
        get() = this

}