package com.hupu.tv.player.app.ui.activity

import android.content.Context
import android.content.Intent
import android.graphics.Paint
import android.text.Html
import android.text.SpannableString
import android.text.TextUtils
import android.text.style.LeadingMarginSpan
import com.mirkowu.basetoolbar.BaseToolbar
import com.softgarden.baselibrary.base.BaseActivity
import com.softgarden.baselibrary.utils.RxPermissionsUtil
import com.softgarden.baselibrary.utils.SPUtil
import com.softgarden.baselibrary.utils.ToastUtil
import com.hupu.tv.player.app.R
import com.hupu.tv.player.app.app.Constants
import com.hupu.tv.player.app.base.RefreshActivity
import com.hupu.tv.player.app.bean.UserBean
import com.hupu.tv.player.app.bean.WithdrawBean
import com.hupu.tv.player.app.ui.contact.ShareActivityContact
import com.hupu.tv.player.app.ui.presenter.ShareActivityPresenter
import com.hupu.tv.player.app.utils.CommonUtils
import com.hupu.tv.player.app.utils.DialogUtils
import com.hupu.tv.player.app.utils.ImageSaveUtil
import com.hupu.tv.player.app.utils.QRCodeUtil
import kotlinx.android.synthetic.main.activity_share_new.*
import kotlinx.android.synthetic.main.layout_title.*


private val link: String
    get() {
        return SPUtil[Constants.SHARE_LINK, ""] as String
    }

class ShareActivity : RefreshActivity<ShareActivityPresenter>(), ShareActivityContact.Display {
    override fun loadData() {

    }

    override fun setToolbar(builder: BaseToolbar.Builder): BaseToolbar.Builder? {
        return null
    }

    override val layoutId: Int
        get() = R.layout.activity_share_new

    override fun initialize() {
        setStatus()
        initView()
    }

    private fun initView() {
        initTitle()
        initData()
        initListener()
    }

    private fun initData() {
        val tvPaint: Paint = tv_share_content.paint
        val rawIndentWidth: Float = tvPaint.measureText("1、 ")
        val spannableString = SpannableString(getString(R.string.string_share_text_tip))
        val what = LeadingMarginSpan.Standard(0, rawIndentWidth.toInt())
        spannableString.setSpan(what, 0, spannableString.length, SpannableString.SPAN_INCLUSIVE_INCLUSIVE)
        tv_share_content.text = spannableString

        presenter?.getWithDraw()
        val userBean = SPUtil.getSerializableObject<UserBean>(Constants.USER_BEAN)
//        var vip = ""
        if (userBean?.isVip == Constants.IS_VIP) {
//            vip = getString(R.string.string_is_vip)
            iv_user_head.background = resources.getDrawable(R.mipmap.bg_icon_vip_head)
        } else {
//            vip = getString(R.string.string_is_not_vip)
            iv_user_head.background = null
            iv_user_head.setFrameColor(resources.getColor(R.color.text_blue))
        }

//        val string = String.format(getString(R.string.string_share_friend_text), vip)
//        val style = SpannableStringBuilder(string)
//        style.setSpan(ForegroundColorSpan(resources.getColor(R.color.share_text)), 3, 5, Spannable.SPAN_EXCLUSIVE_EXCLUSIVE)
//        style.setSpan(ForegroundColorSpan(resources.getColor(R.color.share_text)), 6, 8, Spannable.SPAN_EXCLUSIVE_EXCLUSIVE)
//        style.setSpan(ForegroundColorSpan(resources.getColor(R.color.share_text)), 11, 14, Spannable.SPAN_EXCLUSIVE_EXCLUSIVE)
//        style.setSpan(ForegroundColorSpan(resources.getColor(R.color.share_text)), 31, 34, Spannable.SPAN_EXCLUSIVE_EXCLUSIVE)
//        style.setSpan(ForegroundColorSpan(resources.getColor(R.color.share_text)), 40, 43, Spannable.SPAN_EXCLUSIVE_EXCLUSIVE)
//        tv_describe.text = style
        tv_share_link.text = String.format(getString(R.string.string_share_content_text), link)
        val promoteText = SPUtil[Constants.PROMOTE_TXT, ""] as String
        val isVip = if (userBean?.isVip == Constants.IS_VIP) {
            getString(R.string.string_is_vip)
        } else {
            getString(R.string.string_is_not_vip)
        }
        if (TextUtils.isEmpty(promoteText)) {
            tv_describe.text = promoteText
        } else {
            val fromHtml = Html.fromHtml("$promoteText$isVip")
            val subSequence = if (fromHtml.endsWith("\n\n")) {
                fromHtml.subSequence(0, fromHtml.length - 4)
            } else {
                fromHtml
            }
            tv_describe.text = subSequence
        }


    }


    private fun initListener() {
        //复制链接
        tv_copy_link.setOnClickListener {
            presenter?.copyShareLink()
        }
        //前往分销
        ll_agent.setOnClickListener {
            startActivity(Intent(this, AgentActivity::class.java))
            finish()
        }
        //前往qq
        ll_qq.setOnClickListener {
            CommonUtils.copy(tv_share_link.text.toString())
            DialogUtils.showShareFriend(this, object : DialogUtils.OnClickSingleListener {
                override fun onClick() {
                    startActivity(CommonUtils.toQQ())
                }
            }, Constants.CONTRACT_TYPE_QQ)
        }
        //前往微信
        ll_wx.setOnClickListener {
            CommonUtils.copy(tv_share_link.text.toString())
            DialogUtils.showShareFriend(this, object : DialogUtils.OnClickSingleListener {
                override fun onClick() {
                    startActivity(CommonUtils.toWeChat())
                }
            }, Constants.CONTRACT_TYPE_WE_CHAT)
        }
        //前往微博
        ll_wei_bo.setOnClickListener {
            CommonUtils.copy(tv_share_link.text.toString())
            DialogUtils.showShareFriend(this, object : DialogUtils.OnClickSingleListener {
                override fun onClick() {
                    CommonUtils.openPackage(this@ShareActivity,Constants.TO_WEI_BO,String.format(getString(R.string.string_no_have_to_app),Constants.CONTRACT_WEI_BO_TEXT))
                }
            }, Constants.CONTRACT_TYPE_WEI_BO)
        }
        //前往贴吧
        ll_tie_ba.setOnClickListener {
            CommonUtils.copy(tv_share_link.text.toString())
            DialogUtils.showShareFriend(this, object : DialogUtils.OnClickSingleListener {
                override fun onClick() {
                    CommonUtils.openPackage(this@ShareActivity,Constants.TO_TIE_BA,String.format(getString(R.string.string_no_have_to_app),Constants.CONTRACT_TIE_BA_TEXT))
                }
            }, Constants.CONTRACT_TYPE_TIE_BA)
        }
        //前往贴吧
        ll_zhi_hu.setOnClickListener {
            CommonUtils.copy(tv_share_link.text.toString())
            DialogUtils.showShareFriend(this, object : DialogUtils.OnClickSingleListener {
                override fun onClick() {
                    CommonUtils.openPackage(this@ShareActivity,Constants.TO_ZHI_HU,String.format(getString(R.string.string_no_have_to_app),Constants.CONTRACT_ZHI_HU_TEXT))
                }
            }, Constants.CONTRACT_TYPE_ZHI_HU)
        }
        val bitmap = QRCodeUtil.createQRCodeBitmap(link, 420, 420)
        iv_qr_code.setImageBitmap(bitmap)
        //保存二维码
        ll_save_photo.setOnClickListener {
            RxPermissionsUtil.check(activity, RxPermissionsUtil.STORAGE, "保存相册", object : RxPermissionsUtil.OnPermissionRequestListener {
                override fun onSucceed() {
                    bitmap?.let {
                        val saveImageToGallery = ImageSaveUtil.saveBitmap(it, "ldshen${(Math.random() * 900 + 100).toInt()}")
                        if (saveImageToGallery) {
                            ToastUtil.s("保存成功")
                        } else {
                            ToastUtil.s("保存失败")
                        }
                    }
                }

                override fun onFailed() {
                    ToastUtil.s("保存功能需要开启权限")
                }
            })
        }
    }

    private fun initTitle() {
        tv_title_middle.text = "分享给好友赚会员"
        iv_left_icon.setOnClickListener { finish() }
    }


    override fun onCopyShareLink(link: String?) {
        CommonUtils.copy(tv_share_link.text.toString())
        ToastUtil.s("链接复制成功，快去分享吧")
    }

    override fun onRequest(data: WithdrawBean?) {
        data?.let {
            tv_withdraw.text = String.format(getString(R.string.string_share_text),it.total,it.amount)
        }
    }

    override val ctx: Context?
        get() = this
    override val baseActivity: BaseActivity<*>?
        get() = this

}