package com.hupu.tv.player.app.ui.activity

import android.annotation.SuppressLint
import android.content.Context
import android.view.KeyEvent
import android.view.View
import android.view.ViewGroup
import android.webkit.*
import androidx.core.graphics.drawable.DrawableCompat
import androidx.fragment.app.Fragment
import androidx.recyclerview.widget.LinearLayoutManager
import androidx.recyclerview.widget.RecyclerView
import cc.taylorzhang.singleclick.onSingleClick
import com.flyco.tablayout.utils.FragmentBasePager2Adapter
import com.mirkowu.basetoolbar.BaseToolbar
import com.softgarden.baselibrary.base.BaseActivity
import com.hupu.tv.player.app.R
import com.hupu.tv.player.app.app.Constants
import com.hupu.tv.player.app.base.RefreshActivity
import com.hupu.tv.player.app.bean.RedDetailEntity
import com.hupu.tv.player.app.bean.RedListData
import com.hupu.tv.player.app.bean.SpecialistDetailEntity
import com.hupu.tv.player.app.bean.TitleSortBean
import com.hupu.tv.player.app.ui.adapter.RedDetailAdapter
import com.hupu.tv.player.app.ui.adapter.RedDetailListAdapter
import com.hupu.tv.player.app.ui.adapter.RedLabelAdapter
import com.hupu.tv.player.app.ui.contact.SpecialistDetailContact
import com.hupu.tv.player.app.ui.fragment.HaveMaterialFragment
import com.hupu.tv.player.app.ui.fragment.SpecialistMaterialFragment
import com.hupu.tv.player.app.ui.fragment.SpecialistNewsFragment
import com.hupu.tv.player.app.ui.presenter.SpecialistDetailPresenter
import com.hupu.tv.player.app.utils.CommonUtils
import com.hupu.tv.player.app.utils.DialogUtils
import com.hupu.tv.player.app.utils.GlideUtils
import com.mirkowu.statusbarutil.StatusBarUtil
import com.softgarden.baselibrary.network.ApiException
import com.softgarden.baselibrary.utils.RecyclerViewUtil
import com.softgarden.baselibrary.utils.SPUtil
import com.softgarden.baselibrary.utils.ToastUtil

import kotlinx.android.synthetic.main.activity_specialist_detial.*
import kotlinx.android.synthetic.main.layout_title.*
import java.util.regex.Matcher
import java.util.regex.Pattern


class SpecialistDetailActivity : RefreshActivity<SpecialistDetailPresenter>(),
    SpecialistDetailContact.Display {
    private var specialistId = ""
    private var isFollow = false
    private var mFragments = ArrayList<Fragment>()
    private var mRecentList: ArrayList<String?>? = arrayListOf()
    override fun loadData() {
        presenter?.getSpecialistDetail(specialistId)
    }

    override fun setToolbar(builder: BaseToolbar.Builder): BaseToolbar.Builder? {
        return null
    }

    override val layoutId: Int
        get() = R.layout.activity_specialist_detial

    @SuppressLint("UseCompatLoadingForDrawables")
    override fun initialize() {
        iv_left_icon.setOnClickListener {
            finish()
        }
        tv_title_middle.text = "精选专家"
//        tv_title_middle.setTextColor(getColor(R.color.white))
//        CommonUtils.drawableTint(R.mipmap.icon_back,"#FFFFFF",iv_left_icon)
//        val drawable = resources.getDrawable(R.mipmap.icon_back)
//        val wrap = DrawableCompat.wrap(drawable)
//        DrawableCompat.setTint(wrap,getColor(R.color.white))
//        iv_left_icon.setImageDrawable(wrap)
        specialistId = intent.getStringExtra(Constants.SPECIALIST_ID).orEmpty()
        statusBarTranForView(ll_root)
        initListener()
        initStatusLayout(cl_top as View)
        mStatusLayoutManager.showLoadingLayout()

    }

    private fun initTabLayout(list: List<TitleSortBean>) {
        mFragments.clear()
        val mTitles = arrayOfNulls<String>(list.size)
        list.forEachIndexed { index, titleSortBean ->
            titleSortBean.apply {
                mTitles[index] = sportsName
                if (sportsName == "有料") {
                    mFragments.add(
                        SpecialistMaterialFragment.newInstance(
                            sportsId, sportsName,
                            mRecentList
                        )
                    )
                } else {
                    mFragments.add(
                        SpecialistNewsFragment.newInstance(
                            sportsId,
                            sportsName
                        )
                    )
                }

            }


        }

        val fragmentAdapter =
            FragmentBasePager2Adapter(supportFragmentManager, mFragments, mTitles, lifecycle)
        vp_specialist.adapter = fragmentAdapter
        tabLayout_material.setViewPager2(vp_specialist)
    }

    private fun defaultList(): MutableList<TitleSortBean> {
        return mutableListOf<TitleSortBean>().apply {
            add(TitleSortBean().apply {
                sportsName = "有料"
                sportsId = specialistId
            })

            add(TitleSortBean().apply {
                sportsName = "资讯"
                sportsId = specialistId
            })

        }
    }

    override fun onResume() {
        super.onResume()
        StatusBarUtil.setStatusBarColor(this, getColor(R.color.transparent))
        StatusBarUtil.setStatusBarDarkMode(this, 3)
    }

    private fun initListener() {
        tv_follow.onSingleClick {
            if (SPUtil[Constants.USER_LOGIN, false] == true) {
                if (isFollow) {
                    presenter?.cancelFocus(specialistId)
                } else {
                    presenter?.focus(specialistId)
                }
            } else {
                DialogUtils.showLogin(this)
            }
        }
    }

    private fun setFollow() {
        if (isFollow) {
            tv_follow.text = "已关注"
        } else {
            tv_follow.text = "关注"
        }
    }

    override fun onDetail(data: SpecialistDetailEntity?) {
        mStatusLayoutManager.showSuccessLayout()
        isFollow = data?.follow ?: false
        setFollow()
        GlideUtils.loadAvatar(this, data?.anchorIcon, iv_avatar)
        tv_name.text = data?.anchorName
        tv_describe.text = data?.anchorDesc
//        tv_follow_num.text = "关注：${data?.follows ?: 0}"
        tv_follow_num.text = "${data?.follows ?: 0}"
        mRecentList = data?.record
        initTabLayout(defaultList())
    }

    override fun onFocus() {
        ToastUtil.s("关注成功")
        isFollow = true
        val text = tv_follow_num.text.toString().toInt()
        val successText = text + 1
        tv_follow_num.text = successText.toString()
        setFollow()
    }

    override fun onCancelFocus() {
        ToastUtil.s("取消关注成功")
        val text = tv_follow_num.text.toString().toInt()
        val successText = text - 1
        tv_follow_num.text = successText.toString()
        isFollow = false
        setFollow()
    }

    override val ctx: Context
        get() = this
    override val baseActivity: BaseActivity<*>
        get() = this

}