package com.hupu.tv.player.app.ui.activity


import android.content.Context
import android.content.Intent
import android.util.Log
import android.view.View
import android.widget.TextView
import com.hupu.tv.player.app.BuildConfig
import com.kongzue.dialog.util.BaseDialog
import com.kongzue.dialog.v3.CustomDialog
import com.mirkowu.basetoolbar.BaseToolbar


import com.softgarden.baselibrary.utils.SPUtil
import com.hupu.tv.player.app.R
import com.hupu.tv.player.app.app.App
import com.hupu.tv.player.app.app.Constants
import com.hupu.tv.player.app.base.RefreshActivity
import com.hupu.tv.player.app.ui.contact.SplashActivityContact
import com.hupu.tv.player.app.ui.presenter.SplashActivityPresenter
import com.hupu.tv.player.app.utils.*
import com.mirkowu.statusbarutil.StatusBarUtil
import com.softgarden.baselibrary.base.BaseActivity
import kotlinx.android.synthetic.main.activity_splash.*


class SplashActivity : RefreshActivity<SplashActivityPresenter>(), SplashActivityContact.Display {
    private var tvMessage: TextView? = null
    private var customDialog: CustomDialog? = null
    override val layoutId: Int
        get() = R.layout.activity_splash

    override val baseActivity: BaseActivity<*>?
        get() = this


    override fun onAvatarUrlRequest() {
        mStatusLayoutManager.showSuccessLayout()
        presenter?.startNext()
    }

    override val ctx: Context?
        get() = this

    private fun requestPerMission() {
        goToRequest()

    }

    private fun goToRequest() {
        StatusBar.transportStatus(this@SplashActivity)
        addMessage("存储DeviceId=${DeviceUtils.getDeviceId(this@SplashActivity)}")
        addMessage("请求avatar")
        presenter?.getMainBanner()
    }

    override fun initialize() {
        SPUtil.put(Constants.DEVICE_ID, DeviceUtils.getDeviceId(this@SplashActivity))

        if (BuildConfig.DEBUG) {
//            showLogDialog()
        }
        if (SPUtil[Constants.IS_FIRST_OPEN, true] == true) {
            Log.e("mobclick","IS_FIRST_OPEN")
            SPUtil.put(Constants.IS_FIRST_OPEN,false)
            CommonUtils.umengFirstOpen()
            presenter?.addDownNum()
        }

        StatusBarUtil.setImmersiveTransparentStatusBar(this)
        statusBarTranForView(main_background)
        initStatusLayout(iv_show_ad)
    }

    private fun showLogDialog() {
        customDialog = CustomDialog.show(this, R.layout.transient_notification) { dialog, v ->
            tvMessage = v.findViewById(R.id.message)
            tvMessage?.let {
                presenter?.setTextView(it)
            }
        }
        customDialog?.align = BaseDialog.ALIGN.TOP
    }

    private fun addMessage(message: String) {
        tvMessage?.text = tvMessage?.text.toString() + "\n" + message
    }


    override fun onDestroy() {
        customDialog?.doDismiss()
        window.setBackgroundDrawable(null) //释放资源
        super.onDestroy()
    }

    companion object {
        fun start(context: Context) {
            val starter = Intent(context, SplashActivity::class.java)
            //	    starter.putExtra( );
            context.startActivity(starter)
        }
    }

    override fun loadData() {

        if (!(SPUtil[Constants.IS_AGREE, false] as Boolean)) {
            DialogUtils.showPirvate(this, object : DialogUtils.OnClickListener {
                override fun onRightClick(view: View?) {
                    SPUtil.put(Constants.IS_AGREE, true)
                    App.instance?.initLib()
                    requestPerMission()
                }

                override fun onLeftClick(view: View?) {
                    finish()
                }
            })
        } else {
            requestPerMission()

        }
    }

    override fun setToolbar(builder: BaseToolbar.Builder): BaseToolbar.Builder? {
        return null
    }
}