package com.hupu.tv.player.app.ui.activity

import android.content.Context
import android.content.Intent
import android.view.View
import androidx.recyclerview.widget.LinearLayoutManager
import com.mirkowu.basetoolbar.BaseToolbar
import com.softgarden.baselibrary.base.BaseActivity
import com.hupu.tv.player.app.R
import com.hupu.tv.player.app.app.Constants
import com.hupu.tv.player.app.base.RefreshActivity
import com.hupu.tv.player.app.bean.MatchInfoEntity
import com.hupu.tv.player.app.event.SubscribeEvent
import com.hupu.tv.player.app.ui.adapter.FollowMatchContentAdapter
import com.hupu.tv.player.app.ui.contact.FollowMatchContract
import com.hupu.tv.player.app.ui.presenter.FollowMatchPresenter
import com.hupu.tv.player.app.utils.EmptyConfig
import com.softgarden.baselibrary.utils.RecyclerViewUtil
import com.softgarden.baselibrary.utils.ToastUtil
import kotlinx.android.synthetic.main.activity_report.*
import kotlinx.android.synthetic.main.layout_title_live.*
import org.greenrobot.eventbus.EventBus
import org.greenrobot.eventbus.Subscribe
import org.greenrobot.eventbus.ThreadMode


class SubscribeActivity : RefreshActivity<FollowMatchPresenter>(), FollowMatchContract.Display {
    private lateinit var contentAdapter: FollowMatchContentAdapter
    override fun loadData() {
        mStatusLayoutManager.showSuccessLayout()
        presenter?.getMatchOrder()
    }

    override val layoutId: Int
        get() = R.layout.activity_subscribe

    override fun initialize() {
        EventBus.getDefault().register(this)
        initRefreshLayout()
        initRecyclerView()
        initAdapter()
        tv_title_middle.text = "我的预约"
        iv_left_icon.setOnClickListener {
            finish()
        }
        initStatusLayout(mRefreshLayout as View)
        mStatusLayoutManager.showLoadingLayout()
    }


    private fun initAdapter() {
        contentAdapter = FollowMatchContentAdapter().apply {
            setOnItemClickListener { adapter, view, position ->
                val item = adapter.getItem(position) as MatchInfoEntity
                val intent = Intent(this@SubscribeActivity, NewMatchDetailActivity::class.java)
                intent.putExtra(Constants.MATCH_BEAN_ID, item.id)
                intent.putExtra(Constants.SPORT_TYPE, item.sportsType)
                startActivity(intent)
            }
        }
        mRecyclerView?.apply {
            adapter = contentAdapter
            layoutManager = LinearLayoutManager(activity)
            RecyclerViewUtil.addItemDecoration(this@SubscribeActivity, this, R.color.transparent, Constants.item_divider_4 * 2)
        }
    }

    override fun onMatchList(list: List<MatchInfoEntity>?) {
        mStatusLayoutManager.showSuccessLayout()
        setLoadData(contentAdapter, list, EmptyConfig.NO_FOLLOW_MATCH)
    }

    override fun onSubscribeMatch(id: String, status: Boolean,position:Int) {
        ToastUtil.s(if (status) "预约成功" else "取消成功")
        contentAdapter.remove(position)
    }

    @Subscribe(threadMode = ThreadMode.MAIN, sticky = true, priority = 1)
    fun onEventRegister(event: SubscribeEvent) {
        if (event.className == Constants.SUBSCRIBE_FOLLOW) {
            presenter?.reserveMatch(event.id, event.isStatus,event.position)
        }

    }

    override val ctx: Context?
        get() = this
    override val baseActivity: BaseActivity<*>?
        get() = this

    override fun setToolbar(builder: BaseToolbar.Builder): BaseToolbar.Builder? {
        return null
    }

    override fun onDestroy() {
        super.onDestroy()
        EventBus.getDefault().unregister(this)
    }

}