package com.hupu.tv.player.app.ui.activity

import android.content.Context
import com.mirkowu.basetoolbar.BaseToolbar
import com.softgarden.baselibrary.base.BaseActivity
import com.softgarden.baselibrary.base.IBaseDisplay
import com.softgarden.baselibrary.base.IBasePresenter
import com.softgarden.baselibrary.utils.SPUtil
import com.hupu.tv.player.app.R
import com.hupu.tv.player.app.app.Constants
import com.hupu.tv.player.app.base.RefreshActivity
import com.hupu.tv.player.app.bean.LiveUserBean
import kotlinx.android.synthetic.main.activity_user_coin.*
import kotlinx.android.synthetic.main.layout_title.*


class UserCoinActivity : RefreshActivity<IBasePresenter>(), IBaseDisplay {
    override fun loadData() {

    }

    override fun setToolbar(builder: BaseToolbar.Builder): BaseToolbar.Builder? {
        return null
    }

    override val layoutId: Int
        get() = R.layout.activity_user_coin

    override fun initialize() {
        setStatus()
        tv_title_middle.text = "金币"
        iv_left_icon.setOnClickListener {
            finish()
        }
        setData()
    }

    private fun setData() {
        val liveUserBean = SPUtil.getSerializableObject<LiveUserBean>(Constants.LIVE_USER_BEAN)
        liveUserBean?.let {
            tv_coin.text = it.gold.toString()
        }
    }

    override val ctx: Context?
        get() = this
    override val baseActivity: BaseActivity<*>?
        get() = this

}