package com.hupu.tv.player.app.ui.activity

import android.content.Context
import android.content.Intent
import android.content.pm.ActivityInfo
import android.text.TextUtils
import com.mirkowu.basetoolbar.BaseToolbar
import com.mirkowu.statusbarutil.StatusBarUtil
import com.softgarden.baselibrary.base.BaseActivity

import com.softgarden.baselibrary.utils.SPUtil
import com.softgarden.baselibrary.utils.ToastUtil
import com.hupu.tv.player.app.R
import com.hupu.tv.player.app.app.Constants
import com.hupu.tv.player.app.base.RefreshActivity
import com.hupu.tv.player.app.bean.LiveUserBean
import com.hupu.tv.player.app.event.RefreshUserEvent
import com.hupu.tv.player.app.ui.contact.UserInfoContact
import com.hupu.tv.player.app.ui.presenter.UserInfoPresenter
import com.hupu.tv.player.app.utils.CommonUtils
import com.hupu.tv.player.app.utils.DialogUtils
import com.hupu.tv.player.app.utils.GlideEngine
import com.hupu.tv.player.app.utils.GlideUtils
import com.hupu.tv.player.app.widget.pickview.dialog.ActionListener
import com.hupu.tv.player.app.widget.pickview.dialog.BaseDialogFragment
import com.hupu.tv.player.app.widget.pickview.dialog.DatePickerDialog
import com.luck.picture.lib.PictureSelector
import com.luck.picture.lib.animators.AnimationType
import com.luck.picture.lib.config.PictureConfig
import com.luck.picture.lib.config.PictureMimeType
import com.luck.picture.lib.entity.LocalMedia
import com.luck.picture.lib.listener.OnResultCallbackListener
import com.luck.picture.lib.style.PictureWindowAnimationStyle
import com.luck.picture.lib.tools.SdkVersionUtils
import com.softgarden.baselibrary.utils.RxPermissionsUtil
import kotlinx.android.synthetic.main.activity_user_info.*
import kotlinx.android.synthetic.main.layout_title.*
import org.greenrobot.eventbus.EventBus
import org.greenrobot.eventbus.Subscribe
import org.greenrobot.eventbus.ThreadMode
import java.io.File
import java.util.*


class UserInfoActivity : RefreshActivity<UserInfoPresenter>(), UserInfoContact.Display {
    private var liveUserBean: LiveUserBean? = null
    override fun loadData() {

    }

    override fun setToolbar(builder: BaseToolbar.Builder): BaseToolbar.Builder? {
        return null
    }

    override val layoutId: Int
        get() = R.layout.activity_user_info

    override fun initialize() {
        EventBus.getDefault().register(this)
//        setStatusColor(R.color.white)
        StatusBarUtil.setStatusBarColor(this, getColor(R.color.white))
        StatusBarUtil.setStatusBarLightMode(this, 3)
        liveUserBean = SPUtil.getSerializableObject<LiveUserBean>(Constants.LIVE_USER_BEAN)
        setStatus()
        tv_title_middle.text = "个人信息"
        iv_left_icon.setOnClickListener {
            finish()
        }
        ll_nickname.setOnClickListener {
            startActivity(EditUserNickNameActivity::class.java)
        }
        ll_sex.setOnClickListener {
            DialogUtils.selectSex(this, object : DialogUtils.OnBottomMenuListener {
                override fun onclick(index: Int, text: String) {
                    presenter?.editInfo(
                        liveUserBean?.userName ?: "", index, liveUserBean?.birthday
                            ?: ""
                    )
                }
            })

        }

        ll_birthday.setOnClickListener {
            DatePickerDialog.newInstance(BaseDialogFragment.TYPE_DIALOG, object : ActionListener {
                override fun onDoneClick(dialog: BaseDialogFragment?) {
                    val birthday = getDateString((dialog as DatePickerDialog).selectedDate)
                    presenter?.editInfo(
                        liveUserBean?.userName ?: "", liveUserBean?.sex
                            ?: 0, birthday ?: ""
                    )
                }

                override fun onCancelClick(dialog: BaseDialogFragment?) {

                }
            },true).show(fragmentManager, "dialog")

        }

        ll_avatar.setOnClickListener {
            RxPermissionsUtil.check(
                this,
                RxPermissionsUtil.STORAGE,
                "提示",
                object : RxPermissionsUtil.OnPermissionRequestListener {
                    override fun onSucceed() {
                        openImage()
                    }

                    override fun onFailed() {
                        ToastUtil.s("存储权限未打开，无法上传头像")

//                iv_show_ad.postDelayed({ finish() }, 3000)

                    }
                })

        }


        setData()
    }

    private fun getDateString(date: Calendar): String? {
        val year = date[Calendar.YEAR]
        val month = date[Calendar.MONTH]
        val dayOfMonth = date[Calendar.DAY_OF_MONTH]
        return String.format(Locale.getDefault(), "%d-%02d-%02d", year, month + 1, dayOfMonth)
    }

    private fun openImage() {
        PictureSelector.create(this)
            .openGallery(PictureMimeType.ofImage()) // 全部.PictureMimeType.ofAll()、图片.ofImage()、视频.ofVideo()、音频.ofAudio()
            .imageEngine(GlideEngine.createGlideEngine()) // 外部传入图片加载引擎，必传项
            .setPictureWindowAnimationStyle(PictureWindowAnimationStyle.ofDefaultWindowAnimationStyle()) // 自定义相册启动退出动画
            .setRecyclerAnimationMode(AnimationType.DEFAULT_ANIMATION) // 列表动画效果
            .isMaxSelectEnabledMask(true) // 选择数到了最大阀值列表是否启用蒙层效果
            .maxSelectNum(1)
            .isWithVideoImage(true)
            .maxVideoSelectNum(1) // 视频最大选择数量
            .minSelectNum(1) // 最小选择数量
            .imageSpanCount(3) // 每行显示个数
            .closeAndroidQChangeWH(true) //如果图片有旋转角度则对换宽高,默认为true
            .closeAndroidQChangeVideoWH(!SdkVersionUtils.checkedAndroid_Q()) // 如果视频有旋转角度则对换宽高,默认为false
            .setRequestedOrientation(ActivityInfo.SCREEN_ORIENTATION_UNSPECIFIED) // 设置相册Activity方向，不设置默认使用系统
            .selectionMode(PictureConfig.SINGLE)// 多选 or 单选
            .isPreviewImage(true) // 是否可预览图片
            .isCamera(true) // 是否显示拍照按钮
            .imageFormat(PictureMimeType.PNG) // 拍照保存图片格式后缀,默认jpeg,Android Q使用PictureMimeType.PNG_Q
            .isCompress(true) // 是否压缩
            .compressQuality(50)
            .freeStyleCropEnabled(true) // 裁剪框是否可拖拽
//            .selectionData(gridImageAdapter!!.data) // 是否传入已选图片
            .cutOutQuality(90) // 裁剪输出质量 默认100
            .minimumCompressSize(100) // 小于多少kb的图片不压缩
            .forResult(object : OnResultCallbackListener<LocalMedia> {
                override fun onCancel() {}
                override fun onResult(result: MutableList<LocalMedia>?) {
                    presenter?.uploadFile(result?.get(0)?.compressPath)
                }
            })
    }

    override fun onDestroy() {
        super.onDestroy()
        EventBus.getDefault().unregister(this)
    }

    @Subscribe(threadMode = ThreadMode.MAIN, sticky = true, priority = 1)
    fun onEventRefreshUser(event: RefreshUserEvent) {
        liveUserBean = SPUtil.getSerializableObject<LiveUserBean>(Constants.LIVE_USER_BEAN)
        setData()
    }

    private fun setData() {

        liveUserBean?.let {
            tv_sex.text = when (it.sex) {
                0 -> "保密"
                1 -> "男"
                else -> "女"
            }
            tv_nick_name.text = it.userName
            tv_birthday.text = it.birthday ?: "未填写"
            GlideUtils.loadAvatar(this, it.avatarUrl, iv_avatar)
        }
    }

    override fun onSuccess() {
        hideProgressDialog()
        liveUserBean = SPUtil.getSerializableObject<LiveUserBean>(Constants.LIVE_USER_BEAN)
        ToastUtil.s("修改成功")
        setData()
    }


    override fun onActivityResult(requestCode: Int, resultCode: Int, data: Intent?) {
        super.onActivityResult(requestCode, resultCode, data)
        if (requestCode == REQUEST_OPEN_IMAGE) {
            onActivityResultForLocalPhotos(data)
        }
    }

    private fun onActivityResultForLocalPhotos(data: Intent?) {
        if (data != null) {
            val selectedImage = data.data
            if (selectedImage != null) {
                val filePath =
                    CommonUtils.getRealPathFromUriAboveApiAndroidK(activity, selectedImage)
                if (!TextUtils.isEmpty(filePath) && File(filePath).exists()) {
                    presenter?.uploadFile(filePath!!)
                }
            }
        }
    }

    override val ctx: Context?
        get() = this
    override val baseActivity: BaseActivity<*>?
        get() = this

    companion object {
        const val REQUEST_OPEN_IMAGE = 111
    }
}