package com.hupu.tv.player.app.ui.activity

import android.content.Context
import com.mirkowu.basetoolbar.BaseToolbar
import com.softgarden.baselibrary.base.BaseActivity
import com.softgarden.baselibrary.base.IBaseDisplay
import com.softgarden.baselibrary.base.IBasePresenter
import com.softgarden.baselibrary.utils.SPUtil
import com.hupu.tv.player.app.R
import com.hupu.tv.player.app.app.Constants
import com.hupu.tv.player.app.base.RefreshActivity
import com.hupu.tv.player.app.bean.LiveUserBean
import kotlinx.android.synthetic.main.activity_level.*
import kotlinx.android.synthetic.main.layout_title.*


class UserLevelActivity : RefreshActivity<IBasePresenter>(), IBaseDisplay {
    override fun loadData() {

    }

    override fun setToolbar(builder: BaseToolbar.Builder): BaseToolbar.Builder? {
        return null
    }

    override val layoutId: Int
        get() = R.layout.activity_level

    override fun initialize() {
        setStatus()
        tv_title_middle.text = "等级"
        iv_left_icon.setOnClickListener {
            finish()
        }
        setData()
    }

    private fun setData() {
        val liveUserBean = SPUtil.getSerializableObject<LiveUserBean>(Constants.LIVE_USER_BEAN)
        liveUserBean?.let {
            trp.progress = it.experience
            tv_experience.text = it.experience.toString()
            tv_experience_other.text = it.experience.toString()
            tv_lack_experience.text = it.lackExperience.toString()
            tv_level.text = "LV."+it.level.toString()
            tv_level_other.text =  "LV."+it.level.toString()
            tv_level_describe.text = String.format(getString(R.string.string_next_level, it.lackExperience))
        }
    }

    override val ctx: Context?
        get() = this
    override val baseActivity: BaseActivity<*>?
        get() = this

}