package com.hupu.tv.player.app.ui.activity

import android.content.Context
import android.text.Editable
import android.text.TextWatcher
import com.mirkowu.basetoolbar.BaseToolbar
import com.softgarden.baselibrary.base.BaseActivity
import com.softgarden.baselibrary.utils.ToastUtil
import com.hupu.tv.player.app.R
import com.hupu.tv.player.app.base.RefreshActivity
import com.hupu.tv.player.app.ui.contact.UserToFeedBackContact
import com.hupu.tv.player.app.ui.presenter.UserToFeedBackPresenter
import kotlinx.android.synthetic.main.activity_user_to_feedback.*
import kotlinx.android.synthetic.main.layout_title_live.*


class UserToFeedBackActivity : RefreshActivity<UserToFeedBackPresenter>(), UserToFeedBackContact.Display {
    override fun loadData() {
        presenter?.getFeedBackType()
    }

    override fun setToolbar(builder: BaseToolbar.Builder): BaseToolbar.Builder? {
        return null
    }

    override val layoutId: Int
        get() = R.layout.activity_user_to_feedback

    override fun initialize() {
        setStatus()
        tv_title_middle.text = "举报"
        iv_left_icon.setOnClickListener {
            finish()
        }
        setData()
    }

    private fun setData() {
        tv_suggestion.isSelected = true
        tv_error.isSelected = false
        tv_other.isSelected = false
        tv_suggestion.setOnClickListener {
            tv_suggestion.isSelected = true
            tv_error.isSelected = false
            tv_other.isSelected = false
        }
        tv_error.setOnClickListener {
            tv_error.isSelected = true
            tv_suggestion.isSelected = false
            tv_other.isSelected = false
        }
        tv_other.setOnClickListener {
            tv_other.isSelected = true
            tv_error.isSelected = false
            tv_suggestion.isSelected = false
        }
        et_detail.addTextChangedListener(object : TextWatcher {
            override fun afterTextChanged(s: Editable?) {
                tv_edit_number.text = (500 - (s?.length?:0)).toString()
            }

            override fun beforeTextChanged(s: CharSequence?, start: Int, count: Int, after: Int) {

            }

            override fun onTextChanged(s: CharSequence?, start: Int, before: Int, count: Int) {

            }
        })

        tv_feed.setOnClickListener {
            if (et_detail.text.isNullOrEmpty()){
                ToastUtil.s("请填写举报内容")
                return@setOnClickListener
            }

            ToastUtil.s("提交成功,请等待审核")
            finish()
        }

    }

    override fun onFeedBack() {
        ToastUtil.s("反馈成功")
        finish()
    }

    override fun onFeedBackType() {

    }

    override val ctx: Context?
        get() = this
    override val baseActivity: BaseActivity<*>?
        get() = this

}