package com.hupu.tv.player.app.ui.activity

import android.content.Context
import androidx.recyclerview.widget.LinearLayoutManager

import com.mirkowu.basetoolbar.BaseToolbar
import com.softgarden.baselibrary.base.BaseActivity
import com.softgarden.baselibrary.utils.RecyclerViewUtil
import com.hupu.tv.player.app.R
import com.hupu.tv.player.app.base.RefreshActivity
import com.hupu.tv.player.app.bean.WalletDetailBean
import com.hupu.tv.player.app.ui.adapter.WalletListAdapter
import com.hupu.tv.player.app.ui.contact.WalletDetailContact

import com.hupu.tv.player.app.ui.presenter.WalletDetailPresenter
import com.hupu.tv.player.app.utils.EmptyConfig
import kotlinx.android.synthetic.main.layout_title.*


class WalletDetailActivity : RefreshActivity<WalletDetailPresenter>(), WalletDetailContact.Display {
    private var adapter: WalletListAdapter? = null
    override fun loadData() {
        presenter?.getWalletDetail(mPage)
    }

    override fun setToolbar(builder: BaseToolbar.Builder): BaseToolbar.Builder? {
        return null
    }

    override val layoutId: Int
        get() = R.layout.activity_wallet_detail_list

    override fun initialize() {
        setStatus()
        tv_title_middle.text = "购买明细"
        iv_left_icon.setOnClickListener {
            finish()
        }
        initRecyclerView()
        mRecyclerView?.layoutManager = LinearLayoutManager(this)
        mRecyclerView?.let {
            RecyclerViewUtil.addItemDecorationPx(this, it, R.color.view_withdraw, 1)
        }
        adapter = WalletListAdapter(R.layout.item_wallet)
        adapter?.setEnableLoadMore(true)
        mRecyclerView?.adapter = adapter

    }

    override fun onRequest(list: List<WalletDetailBean.DataListBean>?) {
        adapter?.let {
            setLoadMore(it,list, EmptyConfig.NO_BUY)
        }
    }


    override val ctx: Context?
        get() = this
    override val baseActivity: BaseActivity<*>?
        get() = this

}