package com.hupu.tv.player.app.ui.activity

import android.app.Activity
import android.content.Context
import android.content.Intent
import android.text.TextUtils
import com.mirkowu.basetoolbar.BaseToolbar
import com.softgarden.baselibrary.base.BaseActivity
import com.softgarden.baselibrary.utils.SPUtil
import com.softgarden.baselibrary.utils.ToastUtil
import com.hupu.tv.player.app.R
import com.hupu.tv.player.app.app.Constants
import com.hupu.tv.player.app.base.RefreshActivity
import com.hupu.tv.player.app.bean.UserBean
import com.hupu.tv.player.app.bean.WithdrawBean
import com.hupu.tv.player.app.ui.contact.WithdrawContact
import com.hupu.tv.player.app.ui.presenter.WithdrawPresenter
import kotlinx.android.synthetic.main.activity_withdraw.*
import kotlinx.android.synthetic.main.layout_title.*


class WithdrawActivity : RefreshActivity<WithdrawPresenter>(), WithdrawContact.Display {
    companion object {
        const val REQUEST_DATA = 1;
    }

    override fun loadData() {

    }

    override fun setToolbar(builder: BaseToolbar.Builder): BaseToolbar.Builder? {
        return null
    }

    override val layoutId: Int
        get() = R.layout.activity_withdraw

    override fun initialize() {
        setStatus()
        tv_title_middle.text = "代理分销"
        iv_left_icon.setOnClickListener {
            finish()
        }
        val userBean = SPUtil.getSerializableObject<UserBean>(Constants.USER_BEAN)
        tv_withdraw.setOnClickListener {
            userBean?.let {
                if (TextUtils.isEmpty(it.phone)) {
                    ToastUtil.s("请先绑定手机号码，再申请提现")
                } else {
                    startActivityForResult(Intent(this, WithdrawInfoActivity::class.java), REQUEST_DATA)
//                    startActivity(WithdrawInfoActivity::class.java)
                }
            }

        }
        iv_draw_list.setOnClickListener {
            startActivity(WithdrawRecordActivity::class.java)
        }

        presenter?.getWithDraw()
    }

    override fun onRequest(withdraw: WithdrawBean?) {
        withdraw?.let {
            tv_my_balance.text = String.format(getString(R.string.string_money_label), it.amount)
            tv_all.text = String.format(getString(R.string.string_money_label), it.total)
            tv_first_promote.text = String.format(getString(R.string.string_number_label), it.lv1)
            tv_second_promote.text = String.format(getString(R.string.string_number_label), it.lv2)
            tv_third_promote.text = String.format(getString(R.string.string_number_label), it.lv3)
        }
    }

    override fun onActivityResult(requestCode: Int, resultCode: Int, data: Intent?) {
        if (requestCode == REQUEST_DATA && resultCode == Activity.RESULT_OK) {
            presenter?.getWithDraw()
        }
        super.onActivityResult(requestCode, resultCode, data)
    }


    override val ctx: Context?
        get() = this
    override val baseActivity: BaseActivity<*>?
        get() = this

}