package com.hupu.tv.player.app.ui.activity

import android.app.Activity
import android.content.Context
import android.text.Editable
import android.text.TextUtils
import android.text.TextWatcher
import android.widget.FrameLayout
import com.mirkowu.basetoolbar.BaseToolbar
import com.softgarden.baselibrary.base.BaseActivity
import com.softgarden.baselibrary.utils.SPUtil
import com.softgarden.baselibrary.utils.ScreenUtil
import com.softgarden.baselibrary.utils.ToastUtil
import com.hupu.tv.player.app.R
import com.hupu.tv.player.app.app.Constants
import com.hupu.tv.player.app.base.RefreshActivity
import com.hupu.tv.player.app.ui.contact.WithdrawInfoContact
import com.hupu.tv.player.app.ui.presenter.WithdrawInfoPresenter
import kotlinx.android.synthetic.main.activity_withdraw_info.*
import kotlinx.android.synthetic.main.layout_title.*


class WithdrawInfoActivity : RefreshActivity<WithdrawInfoPresenter>(), WithdrawInfoContact.Display {
    override fun loadData() {

    }

    override fun setToolbar(builder: BaseToolbar.Builder): BaseToolbar.Builder? {
        return null
    }

    override val layoutId: Int
        get() = R.layout.activity_withdraw_info

    override fun initialize() {
//        setStatus()
        val layoutParams = ll_root.layoutParams as FrameLayout.LayoutParams
        layoutParams.topMargin = -ScreenUtil.getStatusBarHeight(this)
        ll_root.requestLayout()
        tv_title_middle.text = "提现"
        iv_left_icon.setOnClickListener {
            finish()
        }
        tv_withdraw.setOnClickListener {

            if (TextUtils.isEmpty(et_money.text.toString())) {
                ToastUtil.s("提现金额不能为空")
                return@setOnClickListener
            }
            if (TextUtils.isEmpty(et_bank_name.text.toString())) {
                ToastUtil.s("支行名称不能为空")
                return@setOnClickListener
            }
            if (TextUtils.isEmpty(et_name.text.toString())) {
                ToastUtil.s("收款人不能为空")
                return@setOnClickListener
            }
            if (TextUtils.isEmpty(et_card_number.text.toString())) {
                ToastUtil.s("银行卡号不能为空")
                return@setOnClickListener
            }

            presenter?.withDraw(et_money.text.toString().toInt(), et_bank_name.text.toString(), et_name.text.toString(), et_card_number.text.toString())
        }
        val fate = SPUtil[Constants.WITHDRAW_FATE, ""] as String
        tv_fate.text = fate
        et_money.addTextChangedListener(object : TextWatcher {
            override fun afterTextChanged(p0: Editable?) {
                if (TextUtils.isEmpty(p0)) {
                    tv_handing_fee.text = getString(R.string.string_system_calculate)
                    tv_amount.text = getString(R.string.string_system_calculate)
                } else {
                    tv_handing_fee.text = (fate.toFloat() * p0.toString().toFloat()).toString()
                    tv_amount.text = (p0.toString().toFloat() - (fate.toFloat() * p0.toString().toFloat())).toString()
                }
            }

            override fun beforeTextChanged(p0: CharSequence?, p1: Int, p2: Int, p3: Int) {

            }

            override fun onTextChanged(p0: CharSequence?, p1: Int, p2: Int, p3: Int) {

            }
        })
    }

    override fun withDrawSuccess() {
        setResult(Activity.RESULT_OK)
        finish()
    }


    override val ctx: Context?
        get() = this
    override val baseActivity: BaseActivity<*>?
        get() = this

}