package com.hupu.tv.player.app.ui.activity

import android.content.Context
import androidx.recyclerview.widget.LinearLayoutManager

import com.mirkowu.basetoolbar.BaseToolbar
import com.softgarden.baselibrary.base.BaseActivity
import com.softgarden.baselibrary.utils.RecyclerViewUtil
import com.hupu.tv.player.app.R
import com.hupu.tv.player.app.base.RefreshActivity
import com.hupu.tv.player.app.bean.WithdrawListBean
import com.hupu.tv.player.app.ui.adapter.WithDrawListAdapter

import com.hupu.tv.player.app.ui.contact.WithdrawRecordContact
import com.hupu.tv.player.app.ui.presenter.WithdrawRecordPresenter
import com.hupu.tv.player.app.utils.EmptyConfig
import kotlinx.android.synthetic.main.layout_title.*


class WithdrawRecordActivity : RefreshActivity<WithdrawRecordPresenter>(), WithdrawRecordContact.Display {
    private var adapter: WithDrawListAdapter? = null
    override fun loadData() {

    }

    override fun setToolbar(builder: BaseToolbar.Builder): BaseToolbar.Builder? {
        return null
    }

    override val layoutId: Int
        get() = R.layout.activity_withdraw_list

    override fun initialize() {
        setStatus()
        tv_title_middle.text = "提现记录"
        iv_left_icon.setOnClickListener {
            finish()
        }
        initRecyclerView()
        mRecyclerView?.layoutManager = LinearLayoutManager(this)
        mRecyclerView?.let {
            RecyclerViewUtil.addItemDecorationPx(this, it, R.color.view_withdraw, 1)
        }
        adapter = WithDrawListAdapter(R.layout.item_withdraw)
        mRecyclerView?.adapter = adapter
        presenter?.getWithDrawList()
    }

    override fun onRequest(list: List<WithdrawListBean>?) {
        adapter?.let {
            setLoadMore(it,list, EmptyConfig.NO_WITHDRAW)
        }

    }


    override val ctx: Context?
        get() = this
    override val baseActivity: BaseActivity<*>?
        get() = this

}