package com.hupu.tv.player.app.ui.adapter;



import androidx.annotation.Nullable;

import com.chad.library.adapter.base.BaseQuickAdapter;
import com.chad.library.adapter.base.BaseViewHolder;
import com.softgarden.baselibrary.base.BaseActivity;
import com.hupu.tv.player.app.R;
import com.hupu.tv.player.app.bean.MovieDetailBean;
import com.hupu.tv.player.app.utils.GlideUtils;

import java.util.List;

/**
 * @author by Dell
 * @date on 2020/6/15
 * @describe
 */
public class ActorAdapter extends BaseQuickAdapter<MovieDetailBean.ActorVOsListBean, BaseViewHolder> {
    private BaseActivity baseActivity;
    public ActorAdapter(int layoutResId, @Nullable List<MovieDetailBean.ActorVOsListBean> data, BaseActivity activity) {
        super(layoutResId, data);
        baseActivity = activity;
    }

    @Override
    protected void convert(BaseViewHolder helper, MovieDetailBean.ActorVOsListBean item) {
        helper.setText(R.id.tv_actor_name,item.getActor());
        GlideUtils.loadCirclePic(baseActivity,item.getPicPath(),helper.getView(R.id.iv_actor));
    }
}
