package com.hupu.tv.player.app.ui.adapter

import android.widget.ImageView
import com.softgarden.baselibrary.base.BaseFragment
import com.chad.library.adapter.base.BaseQuickAdapter
import com.chad.library.adapter.base.BaseViewHolder
import com.hupu.tv.player.app.R
import com.hupu.tv.player.app.app.Constants
import com.hupu.tv.player.app.bean.AnchorEntity
import com.hupu.tv.player.app.utils.GlideUtils

/**
 * @author by Dell
 * @date on 2020/6/15
 * @describe
 */
class AnchorAdapter:
    BaseQuickAdapter<AnchorEntity, BaseViewHolder>(R.layout.item_anchor) {
    override fun convert(helper: BaseViewHolder, item: AnchorEntity) {
        helper.setText(R.id.tv_anchor_name, item.anchorName)
            .setText(R.id.tv_room, item.roomName)
        val ivStatus = helper.getView<ImageView>(R.id.iv_status)
        when (item.liveStatus) {
            Constants.MATCH_STATUS_LIVE -> ivStatus.setImageResource(R.mipmap.match_status_live)
            Constants.MATCH_STATUS_UNSTART -> ivStatus.setImageResource(R.mipmap.match_status_unstart)
            Constants.MATCH_STATUS_END -> ivStatus.setImageResource(R.mipmap.match_status_end)
        }
        GlideUtils.loadAvatar(helper.itemView, item.anchorAvatar, helper.getView(R.id.iv_avatar))
    }
}