package com.hupu.tv.player.app.ui.adapter

import android.annotation.SuppressLint
import android.view.View
import android.widget.ImageView
import android.widget.TextView
import androidx.recyclerview.widget.RecyclerView
import com.chad.library.adapter.base.BaseQuickAdapter
import com.chad.library.adapter.base.BaseViewHolder
import com.hupu.tv.player.app.R
import com.hupu.tv.player.app.app.Constants
import com.hupu.tv.player.app.bean.LiveRankBean
import com.hupu.tv.player.app.bean.MatchInfo
import com.hupu.tv.player.app.bean.SpecialBallItemBean
import com.hupu.tv.player.app.bean.SpecialistBean
import com.hupu.tv.player.app.ui.fragment.LiveRankFragment
import com.hupu.tv.player.app.utils.GlideUtils
import com.softgarden.baselibrary.base.BaseActivity
import com.softgarden.baselibrary.utils.ActivityManager

import com.softgarden.baselibrary.utils.RecyclerViewUtil
import org.w3c.dom.Text

/**
 * @author by Dell
 * @date on 2020/6/15
 * @describe
 */
class ChildMaterialListAdapter(val sportId: String) :
    BaseQuickAdapter<SpecialBallItemBean, BaseViewHolder>(R.layout.child_item_specialist_material) {
    @SuppressLint("ClickableViewAccessibility")
    override fun convert(helper: BaseViewHolder, item: SpecialBallItemBean) {
        helper.setText(R.id.tv_title, item.expert?.title)
            .setText(
                R.id.tv_type,
                    if (sportId.toInt() == Constants.SPORT_TYPE_FOOTBALL) "竟足" else "竟篮"
            )
            .setText(R.id.tv_time, item.expert?.beforeTime)
            .getView<RecyclerView>(R.id.child_recycler).apply {
                setOnTouchListener { v, event -> helper.itemView.onTouchEvent(event) }
                adapter = HaveMaterialListChildAdapter().apply {
                    setNewData(mutableListOf<MatchInfo>().apply {
                        add(item.matchInfo)
                    })
                }
                if (this.itemDecorationCount == 0) {
                    ActivityManager.instance.getCurrent<BaseActivity<*>>()?.let {
                        RecyclerViewUtil.addItemDecoration(
                            it, this, R.color.transparent, 5
                        )
                    }
                }
            }
        helper.getView<ImageView>(R.id.iv_type)
            .setImageResource(if (sportId.toInt() == Constants.SPORT_TYPE_FOOTBALL) R.mipmap.icon_specialist_type_foot else R.mipmap.icon_specialist_type_basket)

    }
}