package com.hupu.tv.player.app.ui.adapter;

import com.chad.library.adapter.base.BaseQuickAdapter;
import com.chad.library.adapter.base.BaseViewHolder;
import com.softgarden.baselibrary.base.BaseActivity;
import com.softgarden.baselibrary.base.BaseFragment;
import com.hupu.tv.player.app.R;
import com.hupu.tv.player.app.bean.MovieBean;
import com.hupu.tv.player.app.utils.GlideUtils;

/**
 * @author by Dell
 * @date on 2020/6/15
 * @describe
 */
public class FindAdapter extends BaseQuickAdapter<MovieBean.RecordsBean, BaseViewHolder> {
    private BaseFragment basefragment;
    private BaseActivity baseActivity;

    public FindAdapter(int layoutResId, BaseFragment fragment) {
        super(layoutResId);
        basefragment = fragment;
    }

    public FindAdapter(int layoutResId, BaseActivity activity) {
        super(layoutResId);
        baseActivity = activity;
    }

    @Override
    protected void convert(BaseViewHolder helper, MovieBean.RecordsBean item) {
        helper.setText(R.id.tv_count, String.valueOf(item.getVideoLike()));
        if (baseActivity != null) {
            GlideUtils.loadRoundCircleImageCenterCrop(baseActivity,
                    item.getVideoEnCover(),
//                "http://wtrpfqnl.cn/play/imageEn/short/202012177379/202012177379.jpg.en",
                    helper.getView(R.id.iv_find), 3, R.mipmap.bg_place_holder_main_normal);
        } else {
            GlideUtils.loadRoundCircleImageCenterCrop(basefragment,
                    item.getVideoEnCover(),
//                "http://wtrpfqnl.cn/play/imageEn/short/202012177379/202012177379.jpg.en",
                    helper.getView(R.id.iv_find), 3, R.mipmap.bg_place_holder_main_normal);
        }

    }
}
