package com.hupu.tv.player.app.ui.adapter

import android.graphics.Color
import android.util.Log
import android.widget.ImageView
import android.widget.TextView
import cc.taylorzhang.singleclick.onSingleClick
import com.chad.library.adapter.base.BaseQuickAdapter
import com.chad.library.adapter.base.BaseViewHolder
import com.hupu.tv.player.app.R
import com.hupu.tv.player.app.app.Constants
import com.hupu.tv.player.app.bean.MatchInfoEntity
import com.hupu.tv.player.app.event.SubscribeEvent
import com.hupu.tv.player.app.utils.GlideUtils
import org.greenrobot.eventbus.EventBus

/**
 * @author by Dell
 * @date on 2020/6/15
 * @describe
 */
class FollowMatchContentAdapter :
    BaseQuickAdapter<MatchInfoEntity, BaseViewHolder>(R.layout.item_match_content_new) {
    override fun convert(
        helper: BaseViewHolder,
        item: MatchInfoEntity
    ) {
        helper
            .setGone(R.id.iv_guest_1, false)
            .setGone(R.id.iv_guest_2, false)
            .setGone(R.id.iv_guest_3, false)
            .getView<ImageView>(R.id.iv_subscribe).apply {
                setImageResource(
                    if (item.subscribe == true) {
                        R.mipmap.match_subscribe
                    } else {
                        R.mipmap.match_unsubscribed
                    }
                )
                onSingleClick {
                    EventBus.getDefault()
                        .post(
                            SubscribeEvent(
                                item.id,
                                !(item.subscribe ?: false),
                                Constants.SUBSCRIBE_FOLLOW, helper.layoutPosition
                            )
                        )
                }
            }

        val homeTeam = item.homeTeam
        val awayTeam = item.awayTeam

        var half = item.halftimeScore?.trim()?.split(":")
        var cornerKick = item.cornerKick?.split(":")
        if (half?.size == 0) {
            Log.e("matchInfo", "half 0 ${half}")
            half = listOf("0", "0")
        }
        if (half?.size == 1) {
            Log.e("matchInfo", "half 1 ${half}")
            half = listOf(if (half[0].isEmpty()) "0" else half[0], "0")
        }

        if (cornerKick?.size == 0) {
            Log.e("matchInfo", "cornerKick 0 ${cornerKick}")
            cornerKick = listOf("0", "0")
        }
        if (cornerKick?.size == 1) {
            Log.e("matchInfo", "cornerKick 1 ${cornerKick}")
            cornerKick = listOf(if (cornerKick[0].isEmpty()) "0" else cornerKick[0], "0")
        }
        helper.setText(R.id.tv_time, item.matchTime)
            .setText(
                R.id.tv_info,
                "半：${half?.get(0)?.trim() ?: 0}-${
                    half?.get(1)?.trim() ?: 0
                }  角：${cornerKick?.get(0) ?: 0}-${
                    cornerKick?.get(1) ?: 0
                }"
            )
            .getView<TextView>(R.id.tv_name).apply {
                text = item.matchShortName
//                if (!item.sportsColor.isNullOrEmpty()) {
//                    CommonUtils.drawableTint(R.mipmap.bg_match_color, item.sportsColor, this)
////                    setBackgroundColor(Color.parseColor(item.sportsColor))
//                }
            }

        when (item.status) {
            Constants.MATCH_TITLE_SCHEDULE_ID -> {
                helper
                    .setGone(R.id.tv_home_score, false)
                    .setGone(R.id.tv_away_score, false)
                    .setText(R.id.tv_status_name, "未开")
                    .getView<TextView>(R.id.tv_status).apply {
                        text = " VS "
                        setTextColor(mContext.getColor(R.color.color_758199))
                    }

            }
            Constants.MATCH_TITLE_START_ID -> {


                helper
                    .setGone(R.id.tv_home_score, true)
                    .setGone(R.id.tv_away_score, true)
                    .setText(R.id.tv_status_name, "已开")
                    .setText(R.id.tv_home_score, (homeTeam?.score ?: 0).toString())
                    .setText(R.id.tv_away_score, (awayTeam?.score ?: 0).toString())
                    .apply {
                        getView<TextView>(R.id.tv_status).apply {
                            text = " - "
                            setTextColor(mContext.getColor(R.color.color_FC7436))
                        }
                        if (item.guides.isNullOrEmpty()) {
                            setGone(R.id.iv_no_guest, true)
                        } else {
                            when (item.guides.size) {
                                1 -> {
                                    setGone(R.id.iv_guest_1, true)
                                    GlideUtils.loadAvatar(itemView, item.guides[0].avatar, getView(R.id.iv_guest_1))
                                }
                                2 -> {
                                    setGone(R.id.iv_guest_1, true)
                                    setGone(R.id.iv_guest_2, true)
                                    GlideUtils.loadAvatar(itemView, item.guides[0].avatar, getView(R.id.iv_guest_1))
                                    GlideUtils.loadAvatar(itemView, item.guides[1].avatar, getView(R.id.iv_guest_2))
                                }
                                3 -> {
                                    setGone(R.id.iv_guest_1, true)
                                    setGone(R.id.iv_guest_2, true)
                                    setGone(R.id.iv_guest_3, true)
                                    GlideUtils.loadAvatar(itemView, item.guides[0].avatar, getView(R.id.iv_guest_1))
                                    GlideUtils.loadAvatar(itemView, item.guides[1].avatar, getView(R.id.iv_guest_2))
                                    GlideUtils.loadAvatar(itemView, item.guides[2].avatar, getView(R.id.iv_guest_3))
                                }
                            }
                            setGone(R.id.iv_no_guest, false)
                        }
                    }


            }
            Constants.MATCH_TITLE_RESULT_ID -> {
                helper
                    .setGone(R.id.tv_home_score, true)
                    .setGone(R.id.tv_away_score, true)
                    .setText(R.id.tv_status_name, "完场")
                    .setText(R.id.tv_home_score, (homeTeam?.score ?: 0).toString())
                    .setText(R.id.tv_away_score, (awayTeam?.score ?: 0).toString())
                    .getView<TextView>(R.id.tv_status).apply {
                        text = " - "
                        setTextColor(mContext.getColor(R.color.color_FC7436))
                    }
            }
        }
        helper.setText(R.id.tv_home, homeTeam?.teamName).setText(R.id.tv_away, awayTeam?.teamName)
        GlideUtils.loadImage(
            helper.itemView,
            homeTeam?.teamIcon,
            helper.getView(R.id.iv_home),
            R.mipmap.place_holder_team_logo_small
        )
        GlideUtils.loadImage(
            helper.itemView,
            awayTeam?.teamIcon,
            helper.getView(R.id.iv_away),
            R.mipmap.place_holder_team_logo_small
        )

    }
}