package com.hupu.tv.player.app.ui.adapter;



import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.app.AppCompatActivity;

import com.chad.library.adapter.base.BaseQuickAdapter;
import com.chad.library.adapter.base.BaseViewHolder;
import com.hupu.tv.player.app.R;
import com.hupu.tv.player.app.bean.GiftBean;
import com.hupu.tv.player.app.utils.GlideUtils;

import java.util.List;

/**
 * @author by Dell
 * @date on 2020/6/15
 * @describe
 */
public class GiftAdapter extends BaseQuickAdapter<GiftBean, BaseViewHolder> {
    private AppCompatActivity baseActivity;
    public GiftAdapter(int layoutResId, @Nullable List<GiftBean> data, AppCompatActivity activity) {
        super(layoutResId, data);
        baseActivity = activity;
    }

    @Override
    protected void convert(BaseViewHolder helper, GiftBean item) {
        helper.setText(R.id.tv_gift_gold,item.getGold()+"金币")
                .setText(R.id.tv_gift_name,item.getGiftName());
        GlideUtils.loadImageGift(baseActivity,item.getGiftImg(),helper.getView(R.id.iv_gift));
    }

    @Override
    public void onBindViewHolder(@NonNull BaseViewHolder holder, int position, @NonNull List<Object> payloads) {
        if (payloads.size() == 0) {
            super.onBindViewHolder(holder, position, payloads);
        } else {
            //暂时改为透明的了。选中效果仍在。
            holder.getView(R.id.ll_gift).setSelected(getData().get(position).isSelect());
        }
    }
}
