package com.hupu.tv.player.app.ui.adapter

import android.annotation.SuppressLint
import android.view.View
import android.widget.ImageView
import android.widget.TextView
import androidx.recyclerview.widget.RecyclerView
import com.chad.library.adapter.base.BaseQuickAdapter
import com.chad.library.adapter.base.BaseViewHolder
import com.hupu.tv.player.app.R
import com.hupu.tv.player.app.bean.LiveRankBean
import com.hupu.tv.player.app.bean.MatchInfo
import com.hupu.tv.player.app.bean.SpecialBallItemBean
import com.hupu.tv.player.app.bean.SpecialistBean
import com.hupu.tv.player.app.ui.fragment.LiveRankFragment
import com.hupu.tv.player.app.utils.GlideUtils
import com.softgarden.baselibrary.base.BaseActivity
import com.softgarden.baselibrary.utils.ActivityManager
import com.softgarden.baselibrary.utils.RecyclerViewUtil
import org.w3c.dom.Text

/**
 * @author by Dell
 * @date on 2020/6/15
 * @describe
 */
class HaveMaterialListAdapter :
    BaseQuickAdapter<SpecialBallItemBean, BaseViewHolder>(R.layout.child_item_have_material) {
    @SuppressLint("ClickableViewAccessibility")
    override fun convert(helper: BaseViewHolder, item: SpecialBallItemBean) {
        GlideUtils.loadAvatar(
            helper.itemView,
            item.expert?.anchorIcon,
            helper.getView(R.id.iv_avatar)
        )
        helper.getView<TextView>(R.id.tv_type).visibility = View.GONE
        item.expert?.tagName?.let {
            if (it.isNotEmpty()) {
                helper.getView<TextView>(R.id.tv_type).visibility = View.VISIBLE
                helper.setText(R.id.tv_type, it[0])
            }
        }
        helper.setText(R.id.tv_name, item.expert?.anchorName)
            .setText(R.id.tv_continue_red, "${item.expert?.continuousWin}连红")
            .setText(R.id.tv_win_rate, "${item.expert?.winRate}%")
            .setText(R.id.tv_title, item.expert?.title)
            .setText(R.id.tv_rate, "${item.expert?.sum ?: 0}中${item.expert?.wins ?: 0}")
            .getView<RecyclerView>(R.id.child_recycler).apply {
                setOnTouchListener { v, event -> helper.itemView.onTouchEvent(event) }
                adapter = HaveMaterialListChildAdapter().apply {
                    setNewData(mutableListOf<MatchInfo>().apply {
                        add(item.matchInfo)
                    })
                }
                if (this.itemDecorationCount == 0) {
                    ActivityManager.instance.getCurrent<BaseActivity<*>>()?.let {
                        RecyclerViewUtil.addItemDecoration(
                            it, this, R.color.transparent, 5
                        )
                    }
                }
            }

    }
}