package com.hupu.tv.player.app.ui.adapter

import android.view.View
import android.widget.ImageView
import android.widget.TextView
import com.chad.library.adapter.base.BaseQuickAdapter
import com.chad.library.adapter.base.BaseViewHolder
import com.hupu.tv.player.app.R
import com.hupu.tv.player.app.bean.LiveRankBean
import com.hupu.tv.player.app.bean.MatchInfo
import com.hupu.tv.player.app.bean.SpecialBallItemBean
import com.hupu.tv.player.app.bean.SpecialistBean
import com.hupu.tv.player.app.ui.fragment.LiveRankFragment
import com.hupu.tv.player.app.utils.GlideUtils

/**
 * @author by Dell
 * @date on 2020/6/15
 * @describe
 */
class HaveMaterialListChildAdapter :
    BaseQuickAdapter<MatchInfo, BaseViewHolder>(R.layout.child_item_specialist) {
    override fun convert(helper: BaseViewHolder, item: MatchInfo) {
        helper.setText(R.id.tv_name,item.matchShortName)
            .setText(R.id.tv_time,"${item.matchDay} ${item.matchTime}")
            .setText(R.id.tv_home_name,item.teamHomeName)
            .setText(R.id.tv_away_name,item.teamAwayName)
            .setText(R.id.tv_score,"${item.homeScore?:0}-${item.awayScore?:0}")

    }
}