package com.hupu.tv.player.app.ui.adapter

import android.view.View
import android.widget.ImageView
import android.widget.TextView
import com.chad.library.adapter.base.BaseQuickAdapter
import com.chad.library.adapter.base.BaseViewHolder
import com.hupu.tv.player.app.R
import com.hupu.tv.player.app.bean.LiveRankBean
import com.hupu.tv.player.app.bean.MaterialScheduleItemEntity
import com.hupu.tv.player.app.bean.SpecialistBean
import com.hupu.tv.player.app.ui.fragment.LiveRankFragment
import com.hupu.tv.player.app.utils.GlideUtils

/**
 * @author by Dell
 * @date on 2020/6/15
 * @describe
 */
class HaveMaterialMatchAdapter :
    BaseQuickAdapter<MaterialScheduleItemEntity, BaseViewHolder>(R.layout.child_match_have_material) {
    override fun convert(helper: BaseViewHolder, item: MaterialScheduleItemEntity) {
        helper.setText(R.id.tv_short_name,item.matchShortName)
            .setText(R.id.tv_time,item.matchTime)
            .setText(R.id.tv_home,item.homeName)
            .setText(R.id.tv_away,item.awayName)
            .setText(R.id.home_odd,item.homeOdds?:"0")
            .setText(R.id.away_odd,item.awayOdds?:"0")
            .setText(R.id.flat_odd,item.flatOdds?:"0")
        GlideUtils.loadImage(helper.itemView,item.homeLogo,helper.getView(R.id.iv_home_logo))
        GlideUtils.loadImage(helper.itemView,item.awayLogo,helper.getView(R.id.iv_away_logo))

    }
}