package com.hupu.tv.player.app.ui.adapter

import android.view.View
import android.widget.ImageView
import android.widget.TextView
import com.chad.library.adapter.base.BaseQuickAdapter
import com.chad.library.adapter.base.BaseViewHolder
import com.hupu.tv.player.app.R
import com.hupu.tv.player.app.bean.LiveRankBean
import com.hupu.tv.player.app.bean.SpecialistBean
import com.hupu.tv.player.app.ui.fragment.LiveRankFragment
import com.hupu.tv.player.app.utils.GlideUtils

/**
 * @author by Dell
 * @date on 2020/6/15
 * @describe
 */
class HaveMaterialSpecialistAdapter :
    BaseQuickAdapter<SpecialistBean, BaseViewHolder>(R.layout.item_have_material) {
    override fun convert(helper: BaseViewHolder, item: SpecialistBean) {
        GlideUtils.loadAvatar(helper.itemView, item.anchorIcon, helper.getView(R.id.iv_avatar))
        item.tagName?.let {
            if (it.isNotEmpty()) {
                helper.setText(R.id.tv_type, it[0])
            }
        }
        helper.setText(R.id.tv_name, item.anchorName)

    }
}