package com.hupu.tv.player.app.ui.adapter

import android.content.Intent
import android.view.View
import android.widget.ImageView
import android.widget.TextView
import com.hupu.tv.player.app.R
import com.hupu.tv.player.app.bean.BannerBean
import com.hupu.tv.player.app.utils.CommonUtils
import com.hupu.tv.player.app.utils.GlideUtils
import com.zhpan.bannerview.BaseBannerAdapter

import com.zhpan.bannerview.BaseViewHolder

/**
 * @author DBoy
 * @date 2020/12/11
 */
class HomeBannerAdapter(private val isNews:Boolean = false) : BaseBannerAdapter<BannerBean?>() {
    override fun bindData(
        holder: BaseViewHolder<BannerBean?>,
        data: BannerBean?,
        position: Int,
        pageSize: Int
    ) {
        holder.itemView.findViewById<ImageView>(R.id.banner_image).apply {
            GlideUtils.loadImage(holder.itemView, data?.picPath, this,R.mipmap.bg_live_main_place_holder)
            if (isNews){
                holder.itemView.findViewById<TextView>(R.id.tv_title).apply {
                    visibility = View.VISIBLE
                    text = data?.title
                }
            }
        }
    }

    override fun getLayoutId(viewType: Int): Int {
        return R.layout.item_slide_mode
    }
}