package com.hupu.tv.player.app.ui.adapter;


import android.view.View;
import android.widget.ImageView;

import androidx.annotation.NonNull;

import com.chad.library.adapter.base.BaseQuickAdapter;
import com.chad.library.adapter.base.BaseViewHolder;
import com.softgarden.baselibrary.base.BaseActivity;
import com.hupu.tv.player.app.R;
import com.hupu.tv.player.app.bean.MovieBean;
import com.hupu.tv.player.app.utils.GlideUtils;

import java.util.List;

/**
 * @author by Dell
 * @date on 2020/6/15
 * @describe
 */
public class HomeCollectionAdapter extends BaseQuickAdapter<MovieBean.RecordsBean, BaseViewHolder> {
    private BaseActivity baseActivity;

    public HomeCollectionAdapter(int layoutResId, BaseActivity activity) {
        super(layoutResId);
        baseActivity = activity;
    }

    @Override
    protected void convert(BaseViewHolder helper, MovieBean.RecordsBean item) {
        View view = helper.getView(R.id.ll_coin);
        if (item.getBuyGoldCoin() == 0){
            view.setVisibility(View.INVISIBLE);
        }else {
            view.setVisibility(View.VISIBLE);
        }

        helper.setText(R.id.tv_title, item.getMovieTitle())
                .setText(R.id.tv_coin,String.valueOf(item.getBuyGoldCoin()));
        ImageView ivSelect = helper.getView(R.id.iv_select);
        if (item.isEdit()) {
            ivSelect.setVisibility(View.VISIBLE);
        } else {
            ivSelect.setVisibility(View.GONE);
        }
        ivSelect.setSelected(item.isSelected());
        helper.addOnClickListener(R.id.iv_select);
        GlideUtils.loadRoundCircleImageCenterCrop(baseActivity,  item.getMovieEnCover(), helper.getView(R.id.iv_cover), 4,R.mipmap.bg_place_holder_history_collection);
//        helper.addOnClickListener(R.id.iv_start);
    }
    public void setEditStatus(boolean editStatus) {
        for (MovieBean.RecordsBean datum : this.getData()) {
            datum.setEdit(editStatus);
        }
        notifyItemRangeChanged(0,getData().size(),"refresh");
    }

    @Override
    public void onBindViewHolder(@NonNull BaseViewHolder holder, int position, @NonNull List<Object> payloads) {
        if (payloads.isEmpty()){
            super.onBindViewHolder(holder, position, payloads);
        }else {
            MovieBean.RecordsBean bean = getData().get(position);
            ImageView ivSelect = holder.getView(R.id.iv_select);
            if (bean.isEdit()) {
                ivSelect.setVisibility(View.VISIBLE);
            } else {
                ivSelect.setVisibility(View.GONE);
            }

            ivSelect.setSelected(bean.isSelected());
        }

    }
}
