package com.hupu.tv.player.app.ui.adapter;

/**
 * @author by Dell
 * @date on 2020/6/15
 * @describe
 */


import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;

import androidx.viewpager.widget.PagerAdapter;
import androidx.viewpager.widget.ViewPager;

import com.softgarden.baselibrary.base.BaseFragment;
import com.hupu.tv.player.app.R;
import com.hupu.tv.player.app.app.App;
import com.hupu.tv.player.app.bean.BannerBean;
import com.hupu.tv.player.app.utils.GlideUtils;

import java.util.List;

public class ImagesPagerAdapter extends PagerAdapter {
    private List<BannerBean> imageViews;
    private ViewPager viewPager;
    public BaseFragment mFragment;
    private ImageView imageView;

    private onItemClickListener onItemClickListener;

    public ImagesPagerAdapter(List<BannerBean> imageViews, ViewPager viewPager, BaseFragment fragment) {
        mFragment = fragment;
        this.imageViews = imageViews;
        this.viewPager = viewPager;
    }

    public void setOnItemClickListener(onItemClickListener onItemClickListener) {
        this.onItemClickListener = onItemClickListener;
    }

    @Override
    public int getCount() {
        return imageViews.size();
    }

    //删除指定位置的页面；适配器负责从view容器中删除view，然而它只保证在finishUpdate(ViewGroup)返回时才完成。
    @Override
    public void destroyItem(ViewGroup container, int position, Object object) {
        // 把ImageView从ViewPager中移除掉
        viewPager.removeView((View) object);
//        super.destroyItem(container, position, object);
    }

    //是否获取缓存
    @Override
    public boolean isViewFromObject(View view, Object object) {
        return view == object;
    }


    //实例化Item
    //在指定的位置创建页面；适配器负责添加view到这个容器中，然而它只保证在finishUpdate(ViewGroup)返回时才完成。
    @Override
    public Object instantiateItem(ViewGroup container, int position) {
//        String url = imageViews.get(position).getPicPath();
        String url = imageViews.get(position).getPicPath();
//        L.e("adapter", "instantiateItem" + position);
        ImageView imageView = new ImageView(App.Companion.getInstance());
        imageView.setScaleType(ImageView.ScaleType.CENTER_CROP);
        LinearLayout.LayoutParams lp = new LinearLayout.LayoutParams(LinearLayout.LayoutParams.MATCH_PARENT, LinearLayout.LayoutParams.MATCH_PARENT);
        imageView.setLayoutParams(lp);
//        GlideUtils.loadRoundCircleImageCenterCrop(mFragment, (String) SPUtil.Companion.get(Constants.SITE,"")+url, imageView, 9);
        GlideUtils.loadRoundCircleImageCenterCrop(mFragment, url, imageView, 8, R.mipmap.bg_live_main_place_holder);
        viewPager.addView(imageView);
        imageView.setOnClickListener(v -> {
            if (onItemClickListener!=null){
                onItemClickListener.onClick(position);
            }
        });
        return imageView;
    }

    @Override
    public int getItemPosition(Object object) {
        return POSITION_NONE;
    }

    /**
     * 无论是创建view添加到容器中  还是 销毁view 都是在此方法结束之后执行的
     * 此方法能保证Viewpager在滚动的时候不会出现闪屏的问题
     */


    @Override
    public void finishUpdate(ViewGroup container) {
        super.finishUpdate(container);
        int position = viewPager.getCurrentItem();
        if (position == 0) {
            position = imageViews.size() - 2;
            viewPager.setCurrentItem(position, false);
        } else if (position == imageViews.size() - 1) {
            position = 1;
            viewPager.setCurrentItem(position, false);
        }
//        L.e("adapter", "finishUpdate" + position + "viewpager.getCurrentItem()" + viewPager.getCurrentItem());
    }

    public interface onItemClickListener {
        void onClick(int position);
    }


/*    private int mChildCount = 0;
    @Override
    public void notifyDataSetChanged() {
        mChildCount = getCount();
        super.notifyDataSetChanged();
    }
    @Override
    public int getItemPosition(Object object) {
        if (mChildCount > 0) {
            mChildCount--;
            L.e("image","getItemPosition");
            return POSITION_NONE;
        }
        return super.getItemPosition(object);
    }*/
}
