package com.hupu.tv.player.app.ui.adapter;

import android.os.Build;

import android.widget.TextView;

import androidx.annotation.RequiresApi;

import com.chad.library.adapter.base.BaseQuickAdapter;
import com.chad.library.adapter.base.BaseViewHolder;
import com.softgarden.baselibrary.BaseApplication;
import com.hupu.tv.player.app.R;

import java.util.List;
import java.util.Objects;

/**
 * @author by Dell
 * @date on 2020/6/15
 * @describe
 */
public class LabelAdapter extends BaseQuickAdapter<String, BaseViewHolder> {
    public LabelAdapter(int layoutResId, List<String> list) {
        super(layoutResId, list);
    }

    @RequiresApi(api = Build.VERSION_CODES.M)
    @Override
    protected void convert(BaseViewHolder helper, String item) {
        int position = helper.getPosition();
        TextView tvLabel = helper.getView(R.id.tv_label);
        if (position % 3 == 0) {
            tvLabel.setTextColor(Objects.requireNonNull(BaseApplication.Companion.getInstance()).getColor(R.color.label_color_1));
        } else if (position % 3 == 1) {
            tvLabel.setTextColor(Objects.requireNonNull(BaseApplication.Companion.getInstance()).getColor(R.color.label_color_2));
        } else if (position % 3 == 2) {
            tvLabel.setTextColor(Objects.requireNonNull(BaseApplication.Companion.getInstance()).getColor(R.color.label_color_3));
        }
        tvLabel.setText(item);
    }
}
