package com.hupu.tv.player.app.ui.adapter

import android.view.View
import android.widget.ImageView
import com.chad.library.adapter.base.BaseQuickAdapter
import com.chad.library.adapter.base.BaseViewHolder
import com.hupu.tv.player.app.R
import com.hupu.tv.player.app.bean.LiveBean
import com.hupu.tv.player.app.utils.GlideUtils

/**
 * @author by Dell
 * @date on 2020/6/15
 * @describe
 */
class LiveItemAdapter :
    BaseQuickAdapter<LiveBean.DataListBean, BaseViewHolder>(R.layout.item_match_normal_live) {
    override fun convert(helper: BaseViewHolder, item: LiveBean.DataListBean) {
        val ivLive = helper.getView<ImageView>(R.id.iv_live)
        val tvRecommend = helper.getView<View>(R.id.tv_recommend)
        GlideUtils.loadImageGif(helper.itemView, R.mipmap.icon_live_living_gif, ivLive)
        if (item.recommend == 1) {
            tvRecommend.visibility = View.VISIBLE
        } else {
            tvRecommend.visibility = View.GONE
        }
        if (item.roomStatus == 1) {
            ivLive.visibility = View.VISIBLE
        } else {
            ivLive.visibility = View.GONE
        }
        GlideUtils.loadAvatar(helper.itemView,item.anchorAvatar,helper.getView(R.id.iv_avatar))

        GlideUtils.loadImage(
            helper.itemView,
            item.matchCutImg,
            helper.getView(R.id.iv_cover),
            R.mipmap.bg_live_place_holder
        )
        helper.setText(R.id.tv_title, item.roomName)
            .setText(R.id.tv_name, item.anchorName)
            .setText(R.id.tv_hot_num, item.hotNum.toString())
    }
}