package com.hupu.tv.player.app.ui.adapter

import android.view.View
import android.widget.ImageView
import android.widget.TextView
import com.chad.library.adapter.base.BaseQuickAdapter
import com.chad.library.adapter.base.BaseViewHolder
import com.hupu.tv.player.app.R
import com.hupu.tv.player.app.app.Constants
import com.hupu.tv.player.app.bean.MatchContentBean.MatchListsBean.MatchInfosBean.GuidesBean
import com.hupu.tv.player.app.utils.GlideUtils
import com.softgarden.baselibrary.base.BaseActivity

/**
 * @author by Dell
 * @date on 2020/6/15
 * @describe
 */
class LiveMatchItemAdapter(layoutResId: Int, private val baseActivity: BaseActivity<*>) : BaseQuickAdapter<GuidesBean, BaseViewHolder>(layoutResId) {
    override fun convert(helper: BaseViewHolder, item: GuidesBean) {
        val ivLive = helper.getView<ImageView>(R.id.iv_live)
        val ivRecommend = helper.getView<View>(R.id.iv_recommend)
        val tvDetialType = helper.getView<TextView>(R.id.tv_detail_type)
        GlideUtils.loadImageGif(baseActivity, R.mipmap.icon_live_living_gif, ivLive)
        if (item.recommend == 1) {
            ivRecommend.visibility = View.VISIBLE
        } else {
            ivRecommend.visibility = View.GONE
        }
        if (item.status == 1) {
            ivLive.visibility = View.VISIBLE
        } else {
            ivLive.visibility = View.GONE
        }
        if (item.sportType == Constants.SPORT_TYPE_BASKETBALL) {
            tvDetialType.text = "篮球"
        } else {
            tvDetialType.text = "足球"
        }
        GlideUtils.loadRoundCircleImageCenterCrop(baseActivity, item.matchCutImg, helper.getView(R.id.iv_cover), 4, R.mipmap.bg_live_place_holder)
        helper.setText(R.id.tv_name, item.name)
        //        GlideUtils.loadAvatar(baseActivity, SPUtil.Companion.get(Constants.AVATAR_URL, "") + item.getAvatar(), helper.getView(R.id.iv_avatar));
        GlideUtils.loadAvatar(baseActivity, item.avatar, helper.getView(R.id.iv_avatar))
    }
}