package com.hupu.tv.player.app.ui.adapter

import android.view.View
import android.widget.ImageView
import android.widget.TextView
import com.chad.library.adapter.base.BaseQuickAdapter
import com.chad.library.adapter.base.BaseViewHolder
import com.hupu.tv.player.app.R
import com.hupu.tv.player.app.bean.LiveRankBean
import com.hupu.tv.player.app.ui.fragment.LiveRankFragment
import com.hupu.tv.player.app.utils.GlideUtils

/**
 * @author by Dell
 * @date on 2020/6/15
 * @describe
 */
class LiveRankAdapter(layoutResId: Int, private val fragment: LiveRankFragment) : BaseQuickAdapter<LiveRankBean?, BaseViewHolder>(layoutResId) {
    override fun convert(helper: BaseViewHolder, item: LiveRankBean?) {
        val tvPosition = helper.getView<TextView>(R.id.tv_position)
        val ivPosition = helper.getView<ImageView>(R.id.iv_position)
        val position = helper.position
        if (position <= 2) {
            ivPosition.visibility = View.VISIBLE
            tvPosition.visibility = View.GONE
            when (position) {
                0 -> {
                    ivPosition.setImageResource(R.mipmap.icon_rank_first)
                }
                1 -> {
                    ivPosition.setImageResource(R.mipmap.icon_rank_second)
                }
                2 -> {
                    ivPosition.setImageResource(R.mipmap.icon_rank_thrid)
                }
            }
        } else {
            ivPosition.visibility = View.GONE
            tvPosition.visibility = View.VISIBLE
            tvPosition.setText(position+1)
        }
        helper.setText(R.id.tv_name,item?.userName)
                .setText(R.id.tv_level,"LV.${item?.userLevel?.toString()}")
                .setText(R.id.tv_reward,fragment.getString(R.string.string_room_reward,item?.goldNum))
        GlideUtils.loadAvatar(fragment,item?.userAvatar,helper.getView(R.id.iv_avatar))
    }
}