package com.hupu.tv.player.app.ui.adapter

import android.annotation.SuppressLint
import android.view.View
import android.widget.ImageView
import android.widget.LinearLayout
import android.widget.TextView
import cc.taylorzhang.singleclick.onSingleClick
import com.chad.library.adapter.base.BaseQuickAdapter
import com.chad.library.adapter.base.BaseViewHolder
import com.hupu.tv.player.app.R
import com.hupu.tv.player.app.app.Constants
import com.hupu.tv.player.app.bean.MatchContentBean
import com.hupu.tv.player.app.event.SubscribeEvent
import com.hupu.tv.player.app.utils.CommonUtils
import com.hupu.tv.player.app.utils.GlideUtils
import com.softgarden.baselibrary.base.BaseFragment

import org.greenrobot.eventbus.EventBus

/**
 * @author by Dell
 * @date on 2020/6/15
 * @describe
 */
class LiveTopAdapter(private val basefragment: BaseFragment<*>) :
    BaseQuickAdapter<MatchContentBean.MatchListsBean.MatchInfosBean, BaseViewHolder>(R.layout.item_match_topl_live_new) {
    @SuppressLint("UseCompatLoadingForDrawables")
    override fun convert(
        helper: BaseViewHolder,
        item: MatchContentBean.MatchListsBean.MatchInfosBean
    ) {
        val time = if (CommonUtils.time == item.matchDate) {
            "今天"
        } else {
            "明天"
        }
        val awayTeam = item.awayTeam
        val homeTeam = item.homeTeam



        GlideUtils.loadImage(
            basefragment,
            homeTeam.teamIcon,
            helper.getView(R.id.iv_team_icon),
            R.mipmap.place_holder_team_logo_small
        )
        GlideUtils.loadImage(
            basefragment,
            awayTeam.teamIcon,
            helper.getView(R.id.iv_team_icon_away),
            R.mipmap.place_holder_team_logo_small
        )
        //tvSubscribe 未开始时显示 status 2
//        val tvSubscribe = helper.getView<TextView>(R.id.tv_subscribe)
        val ivSubscribe = helper.getView<ImageView>(R.id.iv_subscribe)
        //ll_subscribe 未开始 status 2
        val llSubscribe = helper.getView<LinearLayout>(R.id.ll_subscribe)


        //llLive 直播中 status 1
        val llLive = helper.getView<LinearLayout>(R.id.ll_live)
        //2个分数 status = 1
        val tvAwayScore = helper.getView<TextView>(R.id.tv_away_score)
        val tvHomeScore = helper.getView<TextView>(R.id.tv_home_score)

        llLive.visibility = View.GONE

        tvAwayScore.visibility = View.GONE
        tvHomeScore.visibility = View.GONE
        llSubscribe.visibility = View.VISIBLE
//        tvSubscribe.visibility = View.VISIBLE
        ivSubscribe.visibility = View.VISIBLE
        when (item.status) {
            //未开始
            2 -> {
                llSubscribe.visibility = View.VISIBLE
//                tvSubscribe.visibility = View.VISIBLE
                ivSubscribe.visibility = View.VISIBLE
                ivSubscribe.apply {
                    setImageResource(
                        if (item.isSubscribe) {
                            R.mipmap.icon_subscribe_selected
                        } else {
                            R.mipmap.icon_subscribe_normal
                        }
                    )
                    onSingleClick {
                        EventBus.getDefault().post(
                            SubscribeEvent(
                                item.id, !item.isSubscribe,
                                Constants.SUBSCRIBE_TOP
                            )
                        )
                    }
                }

            }
            //直播中
            1 -> {

                ivSubscribe.visibility = View.GONE
                llSubscribe.visibility = View.GONE
                llLive.visibility = View.VISIBLE
                tvAwayScore.visibility = View.VISIBLE
                tvHomeScore.visibility = View.VISIBLE
                tvHomeScore.text = item.homeScore.toString()
                tvAwayScore.text = item.awayScore.toString()
                val iv1 = helper.getView<ImageView>(R.id.iv_1)
                val iv2 = helper.getView<ImageView>(R.id.iv_2)
                val iv3 = helper.getView<ImageView>(R.id.iv_3)
                iv1.visibility = View.VISIBLE
                iv2.visibility = View.VISIBLE
                iv3.visibility = View.VISIBLE
                if (!item.guides.isNullOrEmpty()) {
                    when (item.guides.size) {
                        1 -> {
                            GlideUtils.loadAvatar(basefragment, item.guides[0].avatar, iv1)
                            iv2.visibility = View.GONE
                            iv3.visibility = View.GONE
                        }
                        2 -> {
                            GlideUtils.loadAvatar(basefragment, item.guides[0].avatar, iv1)
                            GlideUtils.loadAvatar(basefragment, item.guides[1].avatar, iv2)
                            iv3.visibility = View.GONE
                        }
                        3 -> {
                            GlideUtils.loadAvatar(basefragment, item.guides[0].avatar, iv1)
                            GlideUtils.loadAvatar(basefragment, item.guides[1].avatar, iv2)
                            GlideUtils.loadAvatar(basefragment, item.guides[2].avatar, iv3)
                        }
                    }
                } else {
                    iv1.visibility = View.GONE
                    iv2.visibility = View.GONE
                    iv3.visibility = View.GONE
                }
            }
            //已结束
        }
        helper.setText(R.id.tv_day, time)
            .setText(R.id.tv_time, item.matchTime)
            .setText(R.id.tv_name, item.matchShortName)
            .setText(R.id.tv_team_name, homeTeam.teamName)
            .setText(R.id.tv_team_name_away, awayTeam.teamName)

    }
}