package com.hupu.tv.player.app.ui.adapter

import com.chad.library.adapter.base.BaseQuickAdapter
import com.chad.library.adapter.base.BaseViewHolder
import com.hupu.tv.player.app.R
import com.hupu.tv.player.app.bean.PlayerListEntity

/**
 * @author by Dell
 * @date on 2020/6/15
 * @describe
 */
class MainPlayerAdapter(layoutResId: Int) : BaseQuickAdapter<PlayerListEntity, BaseViewHolder>(layoutResId) {
    override fun convert(helper: BaseViewHolder, item: PlayerListEntity) {
        val first = if (item.isFirst == 0) {
            "否"
        } else {
            "是"
        }
        helper.setText(R.id.tv_first, first)
                .setText(R.id.tv_name, item.playerName)
                .setText(R.id.tv_player_time, item.playingTime.toString())
                .setText(R.id.tv_score, item.score.toString())
                .setText(R.id.tv_backboard, item.totalBoards.toString())
                .setText(R.id.tv_shoot, "${item.shootNum}-${item.shots}")
                .setText(R.id.tv_three_points, "${item.threeShotNum}-${item.threeShots}")
                .setText(R.id.tv_penalty_shot, "${item.freeThrowNum}-${item.freeThrows}")
                .setText(R.id.tv_assisting, item.assists.toString())
                .setText(R.id.tv_block_a_shot, item.steals.toString())
                .setText(R.id.tv_snatch, item.blocks.toString())
                .setText(R.id.tv_error, item.error.toString())
                .setText(R.id.tv_foul, item.foul.toString())
    }
}