package com.hupu.tv.player.app.ui.adapter

import android.text.TextUtils
import android.view.View
import android.widget.TextView
import com.chad.library.adapter.base.BaseQuickAdapter
import com.chad.library.adapter.base.BaseViewHolder
import com.hupu.tv.player.app.R
import com.hupu.tv.player.app.app.Constants
import com.hupu.tv.player.app.bean.MatchAnalysisEntity
import org.w3c.dom.Text

/**
 * @author by Dell
 * @date on 2020/6/15
 * @describe
 */
class MatchAnalysisAdapter(layoutResId: Int, val sportType:Int = Constants.SPORT_TYPE_FOOTBALL) :
    BaseQuickAdapter<MatchAnalysisEntity, BaseViewHolder>(layoutResId) {
    override fun convert(helper: BaseViewHolder, item: MatchAnalysisEntity) {
        helper.getView<View>(R.id.ll_root).setBackgroundColor(
            when {
                helper.layoutPosition == 0 -> mContext.getColor(R.color.color_F5F6F7)
                (helper.layoutPosition) % 2 == 0 -> mContext.getColor(R.color.color_FCF8F8)
                else -> mContext.getColor(R.color.transparent)
            }
        )

        if (sportType == Constants.SPORT_TYPE_BASKETBALL && helper.layoutPosition !=0){
            helper.getView<TextView>(R.id.tv_loss).setTextColor(mContext.getColor(R.color.color_FC7436))
            helper.getView<TextView>(R.id.tv_make_score).setTextColor(mContext.getColor(R.color.color_FC7436))
        }


        helper
            .setText(R.id.tv_all_score, item.allScore)
            .setText(R.id.tv_name, item.name)
            .setText(R.id.tv_match, item.match)
            .setText(R.id.tv_win, item.win)
            .setText(R.id.tv_tie, item.tie)
            .setText(R.id.tv_loss, item.loss)
            .setText(R.id.tv_make_score, item.makeScore)
            .setText(R.id.tv_point, item.point)
            .setText(R.id.tv_rank, item.rank)
            .setText(R.id.tv_win_rate, item.winRate)
        if (item.allScore.isNullOrEmpty()) {
            helper.getView<TextView>(R.id.tv_all_score).visibility = View.GONE
        }
        if (item.name.isNullOrEmpty()) {
            helper.getView<TextView>(R.id.tv_name).visibility = View.GONE
        }
        if (item.match.isNullOrEmpty()) {
            helper.getView<TextView>(R.id.tv_match).visibility = View.GONE
        }
        if (item.win.isNullOrEmpty()) {
            helper.getView<TextView>(R.id.tv_win).visibility = View.GONE
        }
        if (item.tie.isNullOrEmpty()) {
            helper.getView<TextView>(R.id.tv_tie).visibility = View.GONE
        }
        if (item.loss.isNullOrEmpty()) {
            helper.getView<TextView>(R.id.tv_loss).visibility = View.GONE
        }
        if (item.makeScore.isNullOrEmpty()) {
            helper.getView<TextView>(R.id.tv_make_score).visibility = View.GONE
        }
        if (item.point.isNullOrEmpty()) {
            helper.getView<TextView>(R.id.tv_point).visibility = View.GONE
        }
        if (item.rank.isNullOrEmpty()) {
            helper.getView<TextView>(R.id.tv_rank).visibility = View.GONE
        }
        if (item.winRate.isNullOrEmpty()) {
            helper.getView<TextView>(R.id.tv_win_rate).visibility = View.GONE
        }

    }


}