package com.hupu.tv.player.app.ui.adapter

import android.text.Spannable
import android.text.SpannableStringBuilder
import android.text.style.ForegroundColorSpan
import android.view.View
import android.widget.ImageView
import android.widget.LinearLayout
import android.widget.TextView
import androidx.fragment.app.Fragment
import androidx.recyclerview.widget.LinearLayoutManager
import androidx.recyclerview.widget.RecyclerView
import com.chad.library.adapter.base.BaseQuickAdapter
import com.chad.library.adapter.base.BaseViewHolder
import com.hupu.tv.player.app.R
import com.hupu.tv.player.app.app.App.Companion.instance
import com.hupu.tv.player.app.bean.MatchAnalysisDataEntity
import com.hupu.tv.player.app.bean.MatchRecentDto
import com.hupu.tv.player.app.utils.GlideUtils
import com.softgarden.baselibrary.utils.RecyclerViewUtil

/**
 * @author by Dell
 * @date on 2020/6/15
 * @describe
 */
class MatchAnalysisDataAdapter(
    layoutResId: Int,
    private val homeLogo: String?,
    private val awayLogo: String?,
    val fragment: Fragment
) : BaseQuickAdapter<MatchRecentDto, BaseViewHolder>(layoutResId) {
    override fun convert(helper: BaseViewHolder, item: MatchRecentDto) {

        val llNormal = helper.getView<LinearLayout>(R.id.ll_normal)
        val llSpecial = helper.getView<LinearLayout>(R.id.ll_special)
        llSpecial.visibility = View.GONE
        llNormal.visibility = View.VISIBLE
        val tvNameNormal = helper.getView<TextView>(R.id.tv_name_normal)
        val title =
            "${item.teamRecordName} : ${item.teamRecordWin} ${item.teamRecordTie} ${item.teamRecordLost}"
        val style = SpannableStringBuilder(title)

        style.setSpan(
            ForegroundColorSpan(instance!!.resources.getColor(R.color.color_FC7436)),
            calculateOneStart(item),
            calculateTwoStart(item),
            Spannable.SPAN_EXCLUSIVE_EXCLUSIVE
        )
        style.setSpan(
            ForegroundColorSpan(instance!!.resources.getColor(R.color.blue_match)),
            calculateTwoStart(item),
            calculateThreeStart(item),
            Spannable.SPAN_EXCLUSIVE_EXCLUSIVE
        )
        style.setSpan(
            ForegroundColorSpan(instance!!.resources.getColor(R.color.green_match)),
            calculateThreeStart(item),
            title.length,
            Spannable.SPAN_EXCLUSIVE_EXCLUSIVE
        )
        tvNameNormal.text = style

        val headerView =
            View.inflate(fragment.requireContext(), R.layout.item_analysis_inner_title, null)
        val headIvLogo = headerView.findViewById<ImageView>(R.id.iv_logo)
        val headIvOpponent = headerView.findViewById<ImageView>(R.id.iv_opponent)
        val headTvOpponent = headerView.findViewById<TextView>(R.id.tv_opponent)
        val headLlOpponent = headerView.findViewById<LinearLayout>(R.id.ll_opponent)
        headLlOpponent.visibility = View.GONE
        headTvOpponent.visibility = View.VISIBLE
        when (helper.layoutPosition) {
            0 -> {
                llSpecial.visibility = View.GONE
                llNormal.visibility = View.GONE
                val ivLogoHome = helper.getView<ImageView>(R.id.iv_logo_home)
                val ivLogoAway = helper.getView<ImageView>(R.id.iv_logo_away)
                val tvNameSpecial = helper.getView<TextView>(R.id.tv_name_special)
                tvNameSpecial.text = style
                GlideUtils.loadAvatar(fragment, homeLogo, ivLogoHome)
                GlideUtils.loadAvatar(fragment, homeLogo, headIvLogo)
                GlideUtils.loadAvatar(fragment, awayLogo, ivLogoAway)
                GlideUtils.loadAvatar(fragment, awayLogo, headIvOpponent)
                headLlOpponent.visibility = View.GONE
                headTvOpponent.visibility = View.VISIBLE
            }
            1 -> {

                GlideUtils.loadAvatar(fragment, homeLogo, headIvLogo)
            }
            2 -> {
                GlideUtils.loadAvatar(fragment, awayLogo, headIvLogo)
            }
        }

        val recyclerView = helper.getView<RecyclerView>(R.id.mRecyclerView)
        recyclerView.layoutManager = LinearLayoutManager(fragment.requireContext())
        val innerAdapter = MatchAnalysisInnerAdapter(R.layout.item_analysis_inner)
//        recyclerView?.let {
//            RecyclerViewUtil.addItemDecoration(
//                fragment.requireActivity(),
//                it,
//                R.color.view_color,
//                1f
//            )
//        }
        recyclerView.adapter = innerAdapter
        innerAdapter.addHeaderView(headerView)
        innerAdapter.setNewData(loadData(item.competitionData as ArrayList<ArrayList<String>>?))

    }

    private fun calculateOneStart(item: MatchRecentDto): Int {
        var length = 0
        item.teamRecordName?.let {
            length = it.length + 3
        }
        return length
    }

    private fun calculateTwoStart(item: MatchRecentDto): Int {
        var length = 0
        item.teamRecordWin?.let {
            length = calculateOneStart(item) + it.length + 1
        }
        return length
    }

    private fun calculateThreeStart(item: MatchRecentDto): Int {
        var length = 0
        item.teamRecordTie?.let {
            length = calculateTwoStart(item) + it.length + 1
        }
        return length
    }

    private fun loadData(data: ArrayList<ArrayList<String>>?): MutableList<MatchAnalysisDataEntity> {
        val list = arrayListOf<MatchAnalysisDataEntity>()
        data?.let {
            for (arrayList in it) {
                if (arrayList.size == 5) {
                    list.add(
                        MatchAnalysisDataEntity(
                            arrayList[0],
                            arrayList[1],
                            arrayList[2],
                            arrayList[3],
                            arrayList[4]
                        )
                    )
                }
            }

        }
        return list
    }

}