package com.hupu.tv.player.app.ui.adapter

import android.view.View
import com.chad.library.adapter.base.BaseQuickAdapter
import com.chad.library.adapter.base.BaseViewHolder
import com.hupu.tv.player.app.R
import com.hupu.tv.player.app.bean.MatchAnalysisDataEntity

/**
 * @author by Dell
 * @date on 2020/6/15
 * @describe
 */
class MatchAnalysisInnerAdapter(layoutResId: Int) :
    BaseQuickAdapter<MatchAnalysisDataEntity, BaseViewHolder>(layoutResId) {
    override fun convert(helper: BaseViewHolder, item: MatchAnalysisDataEntity) {

        helper.getView<View>(R.id.ll_root).setBackgroundColor(
            if (helper.layoutPosition % 2 == 0) {
                mContext.getColor(R.color.color_FCF8F8)
            } else {
                mContext.getColor(R.color.transparent)
            }
        )
        helper.setText(R.id.tv_match, item.match)
            .setText(R.id.tv_date, item.date)
            .setText(R.id.tv_field, item.field)
            .setText(R.id.tv_score, item.score)
            .setText(R.id.tv_opponent, item.opponent)
    }

}