package com.hupu.tv.player.app.ui.adapter

import android.content.Intent
import android.view.View
import androidx.appcompat.app.AppCompatActivity
import androidx.recyclerview.widget.LinearLayoutManager
import androidx.recyclerview.widget.OrientationHelper
import androidx.recyclerview.widget.RecyclerView
import com.chad.library.adapter.base.BaseQuickAdapter
import com.chad.library.adapter.base.BaseQuickAdapter.OnItemClickListener
import com.chad.library.adapter.base.BaseViewHolder
import com.hupu.tv.player.app.R
import com.hupu.tv.player.app.app.Constants
import com.hupu.tv.player.app.bean.MatchContentBean
import com.hupu.tv.player.app.ui.activity.NewMatchDetailActivity
import com.hupu.tv.player.app.ui.activity.UserInfoActivity
import com.hupu.tv.player.app.utils.CommonUtils
import com.hupu.tv.player.app.utils.DialogUtils
import com.softgarden.baselibrary.base.BaseFragment
import com.softgarden.baselibrary.utils.RecyclerViewUtil.addItemDecoration
import com.softgarden.baselibrary.utils.RecyclerViewUtil.nestedScrollNoFluent
import com.softgarden.baselibrary.utils.SPUtil

/**
 * @author by Dell
 * @date on 2020/6/15
 * @describe
 */
class MatchContentAdapter(layoutResId: Int, private val baseFragment: BaseFragment<*>) : BaseQuickAdapter<MatchContentBean.MatchListsBean, BaseViewHolder>(layoutResId) {
    override fun convert(helper: BaseViewHolder, item: MatchContentBean.MatchListsBean) {

        val time = when (CommonUtils.getWithCurrentDayDifferent(item.matchTime)) {
            -1 -> {
                "昨天"
            }
            0 -> {
                "今天"
            }
            1 -> {
                "明天"
            }
            2 -> {
                "后天"
            }
            3 -> {
                "大后天"
            }
            else -> {
                "前天"
            }
        }

        helper.setText(R.id.tv_title, time)
        val recyclerView = helper.getView<RecyclerView>(R.id.recycler_content)
        val matchContentIncludeAdapter = MatchContentIncludeAdapter(R.layout.item_match_include_content_new, baseFragment)
        val linearLayoutManager = nestedScrollNoFluent(recyclerView, LinearLayoutManager(baseFragment.activity))
        if (recyclerView.itemDecorationCount == 0) {
            addItemDecoration(baseFragment.activity!!, recyclerView, R.color.view_color, 1, OrientationHelper.VERTICAL)
        }
        recyclerView.layoutManager = linearLayoutManager
        recyclerView.adapter = matchContentIncludeAdapter
        matchContentIncludeAdapter.setNewData(item.matchInfos)
        matchContentIncludeAdapter.onItemClickListener = OnItemClickListener { adapter: BaseQuickAdapter<*, *>, view: View?, position: Int ->
            val adapterItem = adapter.getItem(position) as MatchContentBean.MatchListsBean.MatchInfosBean?
            val intent = Intent(baseFragment.activity, NewMatchDetailActivity::class.java)
            intent.putExtra(Constants.MATCH_BEAN_ID, adapterItem!!.id)
            intent.putExtra(Constants.SPORT_TYPE, adapterItem.sportsType)
            baseFragment.startActivity(intent)


        }
    }
}