package com.hupu.tv.player.app.ui.adapter

import android.content.Intent
import android.view.View
import android.widget.ImageView
import android.widget.LinearLayout
import androidx.appcompat.app.AppCompatActivity
import androidx.recyclerview.widget.LinearLayoutManager
import androidx.recyclerview.widget.RecyclerView
import com.chad.library.adapter.base.BaseQuickAdapter
import com.chad.library.adapter.base.BaseQuickAdapter.OnItemClickListener
import com.chad.library.adapter.base.BaseViewHolder
import com.hupu.tv.player.app.R
import com.hupu.tv.player.app.app.Constants
import com.hupu.tv.player.app.bean.LiveBean
import com.hupu.tv.player.app.bean.MatchContentBean
import com.hupu.tv.player.app.bean.MatchContentBean.MatchListsBean.MatchInfosBean.GuidesBean
import com.hupu.tv.player.app.ui.activity.LiveActivity
import com.hupu.tv.player.app.utils.DialogUtils
import com.hupu.tv.player.app.utils.GlideUtils
import com.softgarden.baselibrary.base.BaseFragment
import com.softgarden.baselibrary.utils.RecyclerViewUtil.nestedScrollNoFluent
import com.softgarden.baselibrary.utils.SPUtil

/**
 * @author by Dell
 * @date on 2020/6/15
 * @describe
 */
class MatchContentIncludeAdapter(layoutResId: Int, private val baseFragment: BaseFragment<*>) : BaseQuickAdapter<MatchContentBean.MatchListsBean.MatchInfosBean, BaseViewHolder>(layoutResId) {
    override fun convert(helper: BaseViewHolder, item: MatchContentBean.MatchListsBean.MatchInfosBean) {
        helper.setText(R.id.tv_time, item.matchTime).setText(R.id.tv_name, item.matchShortName)
        val ivStatus = helper.getView<ImageView>(R.id.iv_status)
        val llScore = helper.getView<LinearLayout>(R.id.ll_score)
        llScore.visibility = View.GONE
        when (item.status) {
            Constants.MATCH_STATUS_LIVE -> {
                llScore.visibility = View.VISIBLE
                ivStatus.setImageResource(R.mipmap.icon_match_staus_live)
            }

            Constants.MATCH_STATUS_UNSTART -> ivStatus.setImageResource(R.mipmap.icon_match_status_unstart)
            Constants.MATCH_STATUS_END -> ivStatus.setImageResource(R.mipmap.icon_match_status_end)
        }
        val homeTeam = item.homeTeam
        val awayTeam = item.awayTeam
        helper.setText(R.id.tv_home, homeTeam.teamName).setText(R.id.tv_away, awayTeam.teamName)
        GlideUtils.loadImage(baseFragment, homeTeam.teamIcon, helper.getView(R.id.iv_home), 0)
        GlideUtils.loadImage(baseFragment, awayTeam.teamIcon, helper.getView(R.id.iv_away), 0)
        helper.setText(R.id.tv_score_home, homeTeam.score.toString())
                .setText(R.id.tv_score_away, awayTeam.score.toString())
        val recyclerView = helper.getView<RecyclerView>(R.id.recycler_content)
        val linearLayoutManager = nestedScrollNoFluent(recyclerView, LinearLayoutManager(baseFragment.activity, RecyclerView.HORIZONTAL, false))
        recyclerView.layoutManager = linearLayoutManager
        val guidesAdapter = GuidesAdapter(R.layout.item_guides_image, baseFragment)
        recyclerView.adapter = guidesAdapter
        guidesAdapter.setNewData(item.guides)
        //        ivSubscribe.setOnClickListener(v -> {
//            if ((Boolean) SPUtil.Companion.get(Constants.USER_LOGIN, false)) {
//                if (item.isSubscribe()) {
//                    ivSubscribe.setImageResource(R.mipmap.match_unsubscribed);
//                    item.setSubscribe(false);
//                } else {
//                    ivSubscribe.setImageResource(R.mipmap.match_subscribe);
//                    item.setSubscribe(true);
//                }
//            }
//            LogUtils.e("event-post-match");
//            EventBus.getDefault().post(new SubscribeEvent(item.getId(), item.isSubscribe(), "match"));
//
//        });
        guidesAdapter.onItemClickListener = OnItemClickListener { adapter: BaseQuickAdapter<*, *>, view: View?, position: Int ->

            val guidesBean = adapter.getItem(position) as GuidesBean?
            val intent = Intent(baseFragment.activity, LiveActivity::class.java)
            intent.putExtra(Constants.ROOM_ID, guidesBean!!.roomId)
            intent.putExtra(Constants.ROOM_COVER, guidesBean.matchCutImg)
            baseFragment.startActivity(intent)


        }
    }
}