package com.hupu.tv.player.app.ui.adapter

import android.text.TextUtils
import android.view.View
import android.widget.ImageView
import android.widget.LinearLayout
import android.widget.RelativeLayout
import android.widget.TextView
import com.chad.library.adapter.base.BaseQuickAdapter
import com.chad.library.adapter.base.BaseViewHolder
import com.hupu.tv.player.app.R
import com.hupu.tv.player.app.bean.MatchDataGoalEntity

/**
 * @author by Dell
 * @date on 2020/6/15
 * @describe
 */
class MatchDataAdapter(layoutResId: Int) : BaseQuickAdapter<MatchDataGoalEntity, BaseViewHolder>(layoutResId) {
    override fun convert(helper: BaseViewHolder, item: MatchDataGoalEntity) {
        val leftView = helper.getView<RelativeLayout>(R.id.rl_left)
        val rightView = helper.getView<RelativeLayout>(R.id.rl_right)
//        val tvLeftIcon = helper.getView<TextView>(R.id.tv_left_icon)
//        val tvRightIcon = helper.getView<TextView>(R.id.tv_right_icon)
        val ivLeftIcon = helper.getView<ImageView>(R.id.iv_left_icon)
        val ivRightIcon = helper.getView<ImageView>(R.id.iv_right_icon)
        val llLeftIcon = helper.getView<LinearLayout>(R.id.ll_left_icon)
        val llRightIcon = helper.getView<LinearLayout>(R.id.ll_right_icon)
        llLeftIcon.visibility =View.INVISIBLE
        llRightIcon.visibility =View.INVISIBLE
        leftView.visibility = View.INVISIBLE
        rightView.visibility = View.INVISIBLE
//        tvLeftIcon.visibility = View.GONE
//        tvRightIcon.visibility = View.GONE
//        changeEventName(item)
        helper.setText(R.id.tv_time, "${item.minutes}'")
        when (item.type) {
            0 -> {
                leftView.visibility = View.VISIBLE
                rightView.visibility = View.VISIBLE

                if (eventNameToRes(item.eventName) == 0) {
//                    tvLeftIcon.visibility = View.VISIBLE
//                    tvLeftIcon.text = item.eventName
//                    tvRightIcon.visibility = View.VISIBLE
//                    tvRightIcon.text = item.eventName
                } else {
                    llRightIcon.visibility =View.VISIBLE
                    llLeftIcon.visibility =View.VISIBLE
                    ivLeftIcon.setImageResource(eventNameToRes(item.eventName))
                    ivRightIcon.setImageResource(eventNameToRes(item.eventName))
                }
                helper.setText(R.id.tv_left_name, item.name)
                        .setText(R.id.tv_left_score, item.score)
                        .setText(R.id.tv_right_name, item.name)
                        .setText(R.id.tv_right_score, item.score)
            }

            1 -> {
                leftView.visibility = View.VISIBLE
                if (eventNameToRes(item.eventName) == 0) {
//                    tvLeftIcon.visibility = View.VISIBLE
//                    tvLeftIcon.text = item.eventName
                } else {
                    llLeftIcon.visibility =View.VISIBLE
                    ivLeftIcon.setImageResource(eventNameToRes(item.eventName))
                }
                helper.setText(R.id.tv_left_name, item.name)
                        .setText(R.id.tv_left_score, item.score)

            }
            2 -> {
                rightView.visibility = View.VISIBLE
                if (eventNameToRes(item.eventName) == 0) {
//                    tvRightIcon.visibility = View.VISIBLE
//                    tvRightIcon.text = item.eventName
                } else {
                    llRightIcon.visibility =View.VISIBLE
                    ivRightIcon.setImageResource(eventNameToRes(item.eventName))
                }
                helper.setText(R.id.tv_right_name, item.name)
                        .setText(R.id.tv_right_score, item.score)
            }
        }
    }


    private fun eventNameToRes(eventName: String?): Int {
        var res = 0
        when (eventName) {
            "乌龙球" -> {
                res = R.mipmap.icon_own_goal
            }
            "点球命中" -> {
                res = R.mipmap.icon_penalty_kick
            }
            "红牌" -> {
                res = R.mipmap.icon_red_warning_card
            }
            "得到一张黄牌" -> {
                res = R.mipmap.icon_warning
            }
            "替补登场" -> {
                res = R.mipmap.icon_swap_in
            }
            "射失点球" -> {
                res = R.mipmap.icon_penalty_kick_error
            }
            "替换下场" -> {
                res = R.mipmap.icon_swap_out
            }
            "两黄一红" -> {
                res = R.mipmap.icon_two_warning
            }
        }

        if (eventName?.contains("得分") == true)  {
            res = R.mipmap.icon_goal
        }
        if (eventName?.contains("进球") == true)  {
            res = R.mipmap.icon_goal
        }
        if (eventName?.contains("助攻") == true)  {
            res = R.mipmap.icon_assists
        }
        return res
    }

}