package com.hupu.tv.player.app.ui.adapter

import android.view.View
import android.widget.ImageView
import android.widget.TextView
import com.chad.library.adapter.base.BaseQuickAdapter
import com.chad.library.adapter.base.BaseViewHolder
import com.hupu.tv.player.app.R
import com.hupu.tv.player.app.app.Constants
import com.hupu.tv.player.app.bean.MatchContentBean.MatchListsBean.MatchInfosBean.GuidesBean
import com.hupu.tv.player.app.utils.GlideUtils
import com.softgarden.baselibrary.base.BaseFragment

/**
 * @author by Dell
 * @date on 2020/6/15
 * @describe
 */
class MatchDetailLiveAdapter : BaseQuickAdapter<GuidesBean, BaseViewHolder>(R.layout.item_match_normal_live) {
    override fun convert(helper: BaseViewHolder, item: GuidesBean) {
        helper.getView<ImageView>(R.id.iv_live).visibility = View.GONE
        helper.getView<View>(R.id.tv_recommend).visibility = View.GONE
        GlideUtils.loadAvatar(helper.itemView,item.avatar,helper.getView(R.id.iv_avatar))
        GlideUtils.loadImage(
            helper.itemView,
            item.matchCutImg,
            helper.getView(R.id.iv_cover),
            R.mipmap.bg_live_news_place_holder
        )
        helper.setText(R.id.tv_title, item.roomName)
            .setText(R.id.tv_name, item.name)
            .setText(R.id.tv_hot_num, item.hotNum.toString())




    }
}