package com.hupu.tv.player.app.ui.adapter

import android.view.View
import android.widget.LinearLayout
import android.widget.TextView
import com.chad.library.adapter.base.BaseQuickAdapter
import com.chad.library.adapter.base.BaseViewHolder
import com.hupu.tv.player.app.R
import com.hupu.tv.player.app.bean.MatchIndexDataEntity

/**
 * @author by Dell
 * @date on 2020/6/15
 * @describe
 */
class MatchIndexAdapter(val type: Int) :
    BaseQuickAdapter<MatchIndexDataEntity, BaseViewHolder>(
        if (type == 2) {
            R.layout.item_match_index_oupei
        } else {
            R.layout.item_match_index
        }
    ) {
    override fun convert(helper: BaseViewHolder, item: MatchIndexDataEntity) {
        if (type == 2) {
            helper.getView<View>(R.id.view_line).visibility = View.VISIBLE
            helper.getView<View>(R.id.ll_second).visibility = View.VISIBLE
            helper.getView<TextView>(R.id.tv_type).text = item.type ?: "-"
            helper.getView<TextView>(R.id.tv_type_second).text = item.typeSecond ?: "-"
            helper.setText(R.id.tv_first_second, item.firstSecond ?: "-")
                .setText(R.id.tv_second_second, item.secondSecond ?: "-")
                .setText(R.id.tv_third_second, item.thirdSecond ?: "-")
                .setText(R.id.tv_fourth_second, item.fourthSecond ?: "-")
                .setText(R.id.tv_fifth_second, item.fifthSecond ?: "-")
                .setText(R.id.tv_sixth_second, item.sixthSecond ?: "-")
        }

        helper.setText(R.id.tv_company, item.company)
            .setText(R.id.tv_first, item.first ?: "-")
            .setText(R.id.tv_second, item.second ?: "-")
            .setText(R.id.tv_third, item.third ?: "-")
            .setText(R.id.tv_fourth, item.fourth ?: "-")
            .setText(R.id.tv_fifth, item.fifth ?: "-")
            .setText(R.id.tv_sixth, item.sixth ?: "-")
        val llIndex = helper.getView<LinearLayout>(R.id.ll_index)
        if (helper.layoutPosition % 2 == 0) {
            llIndex.setBackgroundColor(mContext.getColor(R.color.color_FCF8F8))
        } else {
            llIndex.setBackgroundColor(mContext.getColor(R.color.white))
        }
//        if (helper.layoutPosition == data.size - 1 || helper.layoutPosition == data.size - 2) {
//            llIndex.setBackgroundColor(mContext.getColor(R.color.match_index_bg))
//        }
    }

}