package com.hupu.tv.player.app.ui.adapter

import android.view.View
import com.chad.library.adapter.base.BaseQuickAdapter
import com.chad.library.adapter.base.BaseViewHolder
import com.hupu.tv.player.app.R
import com.hupu.tv.player.app.bean.MatchTeamBean
import kotlin.math.max
import kotlin.math.min

/**
 * @author by Dell
 * @date on 2020/6/15
 * @describe
 */
class MatchTeamAdapter(layoutResId: Int) : BaseQuickAdapter<MatchTeamBean, BaseViewHolder>(layoutResId) {
    override fun convert(helper: BaseViewHolder, item: MatchTeamBean) {
        val viewHome = helper.getView<View>(R.id.view_home)
        val viewAway = helper.getView<View>(R.id.view_away)
        helper.setText(R.id.tv_name, item.name)
                .setText(R.id.tv_score_home, item.homeValue.toString())
                .setText(R.id.tv_score_away, item.awayValue.toString())

        val awayParam = viewAway.layoutParams
        val homeParam = viewHome.layoutParams
        val min = min(item.awayValue, item.homeValue)
        if (min != 0) {
            val k = max(item.awayValue, item.homeValue).div(min.toFloat())

            if (item.awayValue > item.homeValue) {
                awayParam.width = (k * 180).toInt()
                homeParam.width = 180
            } else {
                awayParam.width = 180
                homeParam.width = (k * 180).toInt()
            }
        } else {
            when {
                item.awayValue > item.homeValue -> {
                    when {
                        item.awayValue < 10 -> {
                            awayParam.width = (item.awayValue * 10 + 90)
                        }
                        item.awayValue in 10..20 -> {
                            awayParam.width = (item.awayValue * 5 + 90)
                        }
                        else -> {
                            awayParam.width = (item.awayValue + 90)
                        }
                    }
                    homeParam.width = 90
                }
                else -> {
                    when {
                        item.homeValue < 10 -> {
                            homeParam.width = (item.homeValue * 10 + 90)
                        }
                        item.homeValue in 10..20 -> {
                            homeParam.width = (item.homeValue * 5 + 90)
                        }
                        else -> {
                            homeParam.width = (item.homeValue + 90)
                        }
                    }
                    awayParam.width = 90
                }
            }

        }


    }
}