package com.hupu.tv.player.app.ui.adapter

import android.view.View
import com.chad.library.adapter.base.BaseQuickAdapter
import com.chad.library.adapter.base.BaseViewHolder
import com.hupu.tv.player.app.R
import com.hupu.tv.player.app.bean.GameStat
import com.hupu.tv.player.app.bean.MatchTeamBean
import kotlin.math.max
import kotlin.math.min

/**
 * @author by Dell
 * @date on 2020/6/15
 * @describe
 */
class MatchTechAdapter(layoutResId: Int) : BaseQuickAdapter<GameStat, BaseViewHolder>(layoutResId) {
    override fun convert(helper: BaseViewHolder, item: GameStat) {
        val viewHome = helper.getView<View>(R.id.view_home)
        val viewAway = helper.getView<View>(R.id.view_away)
        helper.setText(R.id.tv_name, item.statName)
                .setText(R.id.tv_score_home, item.statHome)
                .setText(R.id.tv_score_away, item.statAway)
        val intAway = item.statAway?.toInt() ?: 0
        val intHome = item.statHome?.toInt() ?: 0
        val awayParam = viewAway.layoutParams
        val homeParam = viewHome.layoutParams
        val min = min(intAway, intHome)
        if (min != 0) {
            val k = max(intAway, intHome).div(min.toFloat())
            if (intAway > intHome) {
                awayParam.width = (k * 180).toInt()
                homeParam.width = 180
            } else {
                awayParam.width = 180
                homeParam.width = (k * 180).toInt()
            }
        } else {
            when {
                intAway > intHome -> {
                    when {
                        intAway < 10 -> {
                            awayParam.width = (intAway * 10 + 90)
                        }
                        intAway in 10..20 -> {
                            awayParam.width = (intAway * 5 + 90)
                        }
                        else -> {
                            awayParam.width = (intAway + 90)
                        }
                    }
                    homeParam.width = 90
                }
                else -> {
                    when {
                        intHome < 10 -> {
                            homeParam.width = (intHome * 10 + 90)
                        }
                        intHome in 10..20 -> {
                            homeParam.width = (intHome * 5 + 90)
                        }
                        else -> {
                            homeParam.width = (intHome + 90)
                        }
                    }
                    awayParam.width = 90
                }
            }
        }


    }
}