package com.hupu.tv.player.app.ui.adapter

import android.widget.ImageView
import android.widget.TextView
import com.blankj.utilcode.util.SpanUtils
import com.chad.library.adapter.base.BaseQuickAdapter
import com.chad.library.adapter.base.BaseViewHolder
import com.hupu.tv.player.app.R
import com.hupu.tv.player.app.bean.HistoryMessageEntity

/**
 * @author by Dell
 * @date on 2022/3/7
 * @describe
 */
class MessageHistoryAdapter : BaseQuickAdapter<HistoryMessageEntity, BaseViewHolder>(R.layout.custom_row_received_message) {
    override fun convert(helper: BaseViewHolder, item: HistoryMessageEntity) {
        helper.setText(
            R.id.tv_chatcontent, SpanUtils
                .with(helper.getView(R.id.tv_chatcontent))
                .appendImage(R.mipmap.icon_user_level_36)
                .append("  "+item.sendUser + "：")
                .setForegroundColor(mContext.getColor(R.color.user_nick))
                .append(item.msgContent)
                .create()
        )
    }
}